/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressFix
extends AbstractBatchSuppressByNoInspectionCommentFix {
    private String myAlternativeID;

    public SuppressFix(@NotNull HighlightDisplayKey key2) {
        this(key2.getID());
        this.myAlternativeID = HighlightDisplayKey.getAlternativeID((HighlightDisplayKey)key2);
    }

    public SuppressFix(@NotNull String ID) {
        super(ID, false);
    }

    @NotNull
    public String getText() {
        String myText = super.getText();
        return StringUtil.isEmpty((String)myText) ? InspectionsBundle.message((String)"suppress.inspection.member", (Object[])new Object[0]) : myText;
    }

    @Nullable
    public PsiJavaDocumentedElement getContainer(PsiElement context) {
        if (context == null || !BaseIntentionAction.canModify((PsiElement)context)) {
            return null;
        }
        PsiFile containingFile = context.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        if (!containingFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) || context instanceof PsiFile) {
            return null;
        }
        PsiElement container = context;
        while (container instanceof PsiAnonymousClass || !(container instanceof PsiJavaDocumentedElement) || container instanceof PsiTypeParameter) {
            if ((container = PsiTreeUtil.getParentOfType((PsiElement)container, PsiJavaDocumentedElement.class)) != null) continue;
            return null;
        }
        return container instanceof SyntheticElement ? null : (PsiJavaDocumentedElement)container;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
        boolean isValid;
        PsiJavaDocumentedElement container = this.getContainer(context);
        boolean bl = isValid = container != null && (!(container instanceof PsiMethod) || !(container instanceof SyntheticElement));
        if (!isValid) {
            return false;
        }
        if (container instanceof PsiJavaModule) {
            this.setText(InspectionsBundle.message((String)"suppress.inspection.module", (Object[])new Object[0]));
        } else if (container instanceof PsiClass) {
            this.setText(InspectionsBundle.message((String)"suppress.inspection.class", (Object[])new Object[0]));
        } else if (container instanceof PsiMethod) {
            this.setText(InspectionsBundle.message((String)"suppress.inspection.method", (Object[])new Object[0]));
        } else {
            this.setText(InspectionsBundle.message((String)"suppress.inspection.field", (Object[])new Object[0]));
        }
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement element) throws IncorrectOperationException {
        if (this.doSuppress(project, this.getContainer(element))) {
            return;
        }
        UndoUtil.markPsiFileForUndo((PsiFile)element.getContainingFile());
    }

    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"suppress.inspection.member", (Object[])new Object[0]);
    }

    private boolean doSuppress(@NotNull Project project, PsiJavaDocumentedElement container) {
        assert (container != null);
        if (container instanceof PsiModifierListOwner && this.use15Suppressions(container)) {
            PsiModifierListOwner modifierOwner = (PsiModifierListOwner)container;
            PsiModifierList modifierList = modifierOwner.getModifierList();
            if (modifierList != null) {
                JavaSuppressionUtil.addSuppressAnnotation(project, (PsiElement)container, modifierOwner, this.getID((PsiElement)container));
            }
        } else {
            WriteCommandAction.runWriteCommandAction((Project)project, null, null, () -> this.suppressByDocComment(project, container), (PsiFile[])new PsiFile[]{container.getContainingFile()});
        }
        return false;
    }

    private void suppressByDocComment(@NotNull Project project, PsiJavaDocumentedElement container) {
        PsiDocComment docComment = container.getDocComment();
        if (docComment == null) {
            String commentText = "/** @noinspection " + this.getID((PsiElement)container) + "*/";
            docComment = JavaPsiFacade.getElementFactory((Project)project).createDocCommentFromText(commentText);
            PsiElement firstChild = container.getFirstChild();
            container.addBefore((PsiElement)docComment, firstChild);
        } else {
            PsiDocTag noInspectionTag = docComment.findTagByName("noinspection");
            if (noInspectionTag != null) {
                String tagText = noInspectionTag.getText() + ", " + this.getID((PsiElement)container);
                noInspectionTag.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createDocTagFromText(tagText));
            } else {
                String tagText = "@noinspection " + this.getID((PsiElement)container);
                docComment.add((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createDocTagFromText(tagText));
            }
        }
    }

    protected boolean use15Suppressions(@NotNull PsiJavaDocumentedElement container) {
        return JavaSuppressionUtil.canHave15Suppressions((PsiElement)container) && !JavaSuppressionUtil.alreadyHas14Suppressions(container) && !SuppressFix.isInjectedToStringLiteral(container);
    }

    private static boolean isInjectedToStringLiteral(@NotNull PsiJavaDocumentedElement container) {
        return JavaResolveUtil.findParentContextOfClass((PsiElement)container, PsiLiteralExpression.class, true) != null;
    }

    private String getID(@NotNull PsiElement place) {
        String id = SuppressFix.getID(place, this.myAlternativeID);
        return id != null ? id : this.myID;
    }

    @Nullable
    static String getID(@NotNull PsiElement place, String alternativeID) {
        Module module;
        if (alternativeID != null && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)place)) != null && ClassPathStorageUtil.isClasspathStorage((Module)module)) {
            return alternativeID;
        }
        return null;
    }
}

