/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.actions.AbstractBatchSuppressByNoInspectionCommentFix;
import com.intellij.codeInsight.daemon.impl.actions.SuppressFix;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressParameterFix
extends AbstractBatchSuppressByNoInspectionCommentFix {
    private String myAlternativeID;

    public SuppressParameterFix(@NotNull HighlightDisplayKey key2) {
        this(key2.getID());
        this.myAlternativeID = HighlightDisplayKey.getAlternativeID((HighlightDisplayKey)key2);
    }

    public SuppressParameterFix(String ID) {
        super(ID, false);
    }

    @NotNull
    public String getText() {
        return "Suppress for parameter";
    }

    @Nullable
    public PsiElement getContainer(PsiElement context) {
        PsiParameter psiParameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)context, PsiParameter.class, (boolean)false);
        return psiParameter != null && psiParameter.getTypeElement() != null && JavaSuppressionUtil.canHave15Suppressions((PsiElement)psiParameter) ? psiParameter : null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected boolean replaceSuppressionComments(PsiElement container) {
        return false;
    }

    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element, @NotNull PsiElement cont) throws IncorrectOperationException {
        PsiModifierListOwner container = (PsiModifierListOwner)cont;
        PsiModifierList modifierList = container.getModifierList();
        if (modifierList != null) {
            String id = SuppressFix.getID((PsiElement)container, this.myAlternativeID);
            JavaSuppressionUtil.addSuppressAnnotation(project, (PsiElement)container, container, id != null ? id : this.myID);
        }
    }
}

