/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuppressWarningsFoldingBuilder
extends FoldingBuilderEx {
    private static final Logger LOG = Logger.getInstance(SuppressWarningsFoldingBuilder.class);

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (!(root instanceof PsiJavaFile) || quick || !JavaCodeFoldingSettings.getInstance().isCollapseSuppressWarnings()) {
            return FoldingDescriptor.EMPTY;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)root)) {
            return FoldingDescriptor.EMPTY;
        }
        final ArrayList result = new ArrayList();
        root.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                if (Comparing.strEqual((String)annotation.getQualifiedName(), (String)SuppressWarnings.class.getName())) {
                    result.add(new NamedFoldingDescriptor(annotation.getNode(), annotation.getTextRange(), null, SuppressWarningsFoldingBuilder.placeholderText(annotation), Boolean.valueOf(JavaCodeFoldingSettings.getInstance().isCollapseSuppressWarnings()), Collections.emptySet()));
                }
                super.visitAnnotation(annotation);
            }
        });
        return result.toArray(FoldingDescriptor.EMPTY);
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        LOG.error("unknown element " + node);
        return null;
    }

    @NotNull
    private static String placeholderText(@NotNull PsiAnnotation element) {
        return "/" + StringUtil.join((Object[])element.getParameterList().getAttributes(), value2 -> SuppressWarningsFoldingBuilder.getMemberValueText(value2.getValue()), (String)", ") + "/";
    }

    @NotNull
    private static String getMemberValueText(@Nullable PsiAnnotationMemberValue _memberValue) {
        return StringUtil.join((Collection)AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)_memberValue), memberValue -> {
            Object o;
            if (memberValue instanceof PsiLiteral && (o = ((PsiLiteral)memberValue).getValue()) != null) {
                return o.toString();
            }
            return memberValue != null ? memberValue.getText() : "";
        }, (String)", ");
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        return JavaCodeFoldingSettings.getInstance().isCollapseSuppressWarnings();
    }
}

