/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.util.xmlb.annotations.Attribute;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ErrorFixExtensionPoint
extends AbstractExtensionPointBean {
    public static final ExtensionPointName<ErrorFixExtensionPoint> ERROR_FIX_EXTENSION_POINT = ExtensionPointName.create((String)"com.intellij.java.error.fix");
    @Attribute(value="errorCode")
    public String errorCode;
    @Attribute(value="implementationClass")
    public String implementationClass;
    private static volatile Map<String, List<ErrorFixExtensionPoint>> ourCodeToFix;

    IntentionAction instantiate(PsiElement context) {
        try {
            return this.findClass(this.implementationClass).asSubclass(IntentionAction.class).getConstructor(PsiElement.class).newInstance(context);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)e.getCause();
            }
            throw new RuntimeException("Error instantiating quick-fix " + this.implementationClass + " (error code: " + this.errorCode + ")", e.getCause());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException("Error instantiating quick-fix " + this.implementationClass + " (error code: " + this.errorCode + ")", e);
        }
    }

    @NotNull
    private static Map<String, List<ErrorFixExtensionPoint>> getCodeToFixMap() {
        Map map2 = ourCodeToFix;
        if (map2 == null) {
            ourCodeToFix = map2 = StreamEx.of((Object[])ERROR_FIX_EXTENSION_POINT.getExtensions()).groupingBy(fix2 -> fix2.errorCode);
        }
        return map2;
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static HighlightInfo registerFixes(@Nullable HighlightInfo info, @NotNull PsiElement context, @NotNull @PropertyKey(resourceBundle="messages.JavaErrorMessages") String code) {
        if (info == null) {
            return null;
        }
        List<ErrorFixExtensionPoint> fixes = ErrorFixExtensionPoint.getCodeToFixMap().get(code);
        for (ErrorFixExtensionPoint fix2 : fixes) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)fix2.instantiate(context));
        }
        return info;
    }
}

