/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.pom.java.AcceptedLanguageLevelsSettings;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncreaseLanguageLevelFix
implements IntentionAction,
LocalQuickFix {
    private final LanguageLevel myLevel;

    public IncreaseLanguageLevelFix(@NotNull LanguageLevel targetLevel) {
        this.myLevel = targetLevel;
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"set.language.level.to.0", (Object[])new Object[]{this.myLevel.getPresentableText()});
    }

    @Nls
    @NotNull
    public String getName() {
        return this.getText();
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"set.language.level", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        this.invoke(project, null, element.getContainingFile());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        return module != null && JavaSdkUtil.isLanguageLevelAcceptable(project, module, this.myLevel) && AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(this.myLevel);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null) {
            JavaProjectModelModificationService.getInstance(project).changeLanguageLevel(module, this.myLevel);
        }
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

