/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExceptionToCatchFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddFinallyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiTryStatement;
import org.jetbrains.annotations.NotNull;

public class JavaErrorQuickFixProvider
implements ErrorQuickFixProvider {
    public void registerErrorQuickFix(@NotNull PsiErrorElement errorElement, @NotNull HighlightInfo highlightInfo) {
        PsiElement parent = errorElement.getParent();
        if (parent instanceof PsiTryStatement && errorElement.getErrorDescription().equals(JavaErrorMessages.message("expected.catch.or.finally", new Object[0]))) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new AddExceptionToCatchFix(false));
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new AddFinallyFix((PsiTryStatement)parent));
        }
    }
}

