/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaHighlightingUtil {
    private static final Logger LOG = Logger.getInstance(LambdaHighlightingUtil.class);

    @Nullable
    public static String checkInterfaceFunctional(@NotNull PsiClass psiClass) {
        return LambdaHighlightingUtil.checkInterfaceFunctional(psiClass, "Target type of a lambda conversion must be an interface");
    }

    @Nullable
    static String checkInterfaceFunctional(@NotNull PsiClass psiClass, String interfaceNonFunctionalMessage) {
        if (psiClass instanceof PsiTypeParameter) {
            return null;
        }
        List signatures = LambdaUtil.findFunctionCandidates((PsiClass)psiClass);
        if (signatures == null) {
            return interfaceNonFunctionalMessage;
        }
        if (signatures.isEmpty()) {
            return "No target method found";
        }
        if (signatures.size() == 1) {
            return null;
        }
        return "Multiple non-overriding abstract methods found in interface " + HighlightUtil.formatClass(psiClass);
    }

    @Nullable
    static HighlightInfo checkParametersCompatible(PsiLambdaExpression expression2, PsiParameter[] methodParameters, PsiSubstitutor substitutor) {
        PsiParameter[] lambdaParameters = expression2.getParameterList().getParameters();
        String incompatibleTypesMessage = "Incompatible parameter types in lambda expression: ";
        if (lambdaParameters.length != methodParameters.length) {
            incompatibleTypesMessage = incompatibleTypesMessage + "wrong number of parameters: expected " + methodParameters.length + " but found " + lambdaParameters.length;
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2.getParameterList()).descriptionAndTooltip(incompatibleTypesMessage).create();
        }
        boolean hasFormalParameterTypes = expression2.hasFormalParameterTypes();
        for (int i = 0; i < lambdaParameters.length; ++i) {
            PsiParameter lambdaParameter = lambdaParameters[i];
            PsiType lambdaParameterType = lambdaParameter.getType();
            PsiType substitutedParamType = substitutor.substitute(methodParameters[i].getType());
            if ((!hasFormalParameterTypes || PsiTypesUtil.compareTypes((PsiType)lambdaParameterType, (PsiType)substitutedParamType, (boolean)true)) && TypeConversionUtil.isAssignable((PsiType)substitutedParamType, (PsiType)lambdaParameterType)) continue;
            String expectedType = substitutedParamType != null ? substitutedParamType.getPresentableText() : null;
            String actualType = lambdaParameterType.getPresentableText();
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)expression2.getParameterList()).descriptionAndTooltip(incompatibleTypesMessage + "expected " + expectedType + " but found " + actualType).create();
        }
        return null;
    }

    public static boolean insertSemicolonAfter(PsiLambdaExpression lambdaExpression) {
        return lambdaExpression.getBody() instanceof PsiCodeBlock || !LambdaHighlightingUtil.insertSemicolon(lambdaExpression.getParent());
    }

    public static boolean insertSemicolon(PsiElement parent) {
        return parent instanceof PsiExpressionList || parent instanceof PsiExpression;
    }

    @Nullable
    public static String checkInterfaceFunctional(PsiType functionalInterfaceType) {
        if (functionalInterfaceType instanceof PsiIntersectionType) {
            HashSet<MethodSignature> signatures = new HashSet<MethodSignature>();
            for (PsiType type2 : ((PsiIntersectionType)functionalInterfaceType).getConjuncts()) {
                if (LambdaHighlightingUtil.checkInterfaceFunctional(type2) != null) continue;
                MethodSignature signature = LambdaUtil.getFunction((PsiClass)PsiUtil.resolveClassInType((PsiType)type2));
                LOG.assertTrue(signature != null, (Object)type2.getCanonicalText());
                signatures.add(signature);
            }
            if (signatures.size() > 1) {
                return "Multiple non-overriding abstract methods found in " + functionalInterfaceType.getPresentableText();
            }
            return null;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiClass aClass = resolveResult.getElement();
        if (aClass != null) {
            if (aClass instanceof PsiTypeParameter) {
                return null;
            }
            MethodSignature functionalMethod = LambdaUtil.getFunction((PsiClass)aClass);
            if (functionalMethod != null && functionalMethod.getTypeParameters().length > 0) {
                return "Target method is generic";
            }
            return LambdaHighlightingUtil.checkInterfaceFunctional(aClass);
        }
        return functionalInterfaceType.getPresentableText() + " is not a functional interface";
    }

    public static HighlightInfo checkConsistentParameterDeclaration(PsiLambdaExpression expression2) {
        PsiParameter[] parameters2 = expression2.getParameterList().getParameters();
        if (parameters2.length < 2) {
            return null;
        }
        boolean hasExplicitParameterTypes = LambdaHighlightingUtil.hasExplicitType(parameters2[0]);
        for (int i = 1; i < parameters2.length; ++i) {
            if (hasExplicitParameterTypes == LambdaHighlightingUtil.hasExplicitType(parameters2[i])) continue;
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip("Cannot mix 'var' and explicitly typed parameters in lambda expression").range((PsiElement)expression2.getParameterList()).create();
        }
        return null;
    }

    private static boolean hasExplicitType(PsiParameter parameter2) {
        PsiTypeElement typeElement = parameter2.getTypeElement();
        return typeElement != null && !typeElement.isInferredType();
    }
}

