/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.pom.java.AcceptedLanguageLevelsSettings;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class LocalVariableTypeInferenceUnresolvedFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        LanguageLevel targetLanguageLevel;
        PsiElement typeElement = ref.getParent();
        PsiElement parent = typeElement instanceof PsiTypeElement ? typeElement.getParent() : null;
        boolean increaseLanguageLevel = true;
        if (parent instanceof PsiParameter && ((PsiParameter)parent).getDeclarationScope() instanceof PsiLambdaExpression) {
            if (LanguageLevel.HIGHEST.isAtLeast(LanguageLevel.JDK_11)) {
                targetLanguageLevel = LanguageLevel.JDK_11;
            } else {
                if (!AcceptedLanguageLevelsSettings.isLanguageLevelAccepted(LanguageLevel.JDK_11)) return;
                targetLanguageLevel = LanguageLevel.JDK_11;
                increaseLanguageLevel = false;
            }
        } else {
            targetLanguageLevel = LanguageLevel.JDK_10;
        }
        if (PsiUtil.getLanguageLevel((PsiElement)ref).isAtLeast(targetLanguageLevel)) {
            return;
        }
        if (!"var".equals(ref.getReferenceName())) {
            return;
        }
        if (increaseLanguageLevel) {
            registrar.register(QuickFixFactory.getInstance().createIncreaseLanguageLevelFix(targetLanguageLevel));
        }
        registrar.register(QuickFixFactory.getInstance().createShowModulePropertiesFix((PsiElement)ref));
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        return PsiJavaCodeReferenceElement.class;
    }
}

