/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExportsDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddUsesDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.GoToSymbolFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeModuleStatementsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ModuleHighlightUtil {
    static HighlightInfo checkPackageStatement(@NotNull PsiPackageStatement statement, @NotNull PsiFile file, @Nullable PsiJavaModule module) {
        PsiJavaModule origin;
        String packageName;
        if (PsiUtil.isModuleFile((PsiFile)file)) {
            String message2 = JavaErrorMessages.message("module.no.package", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)statement));
            return info;
        }
        if (module != null && (packageName = statement.getPackageName()) != null && (origin = JavaModuleGraphUtil.findOrigin(module, packageName)) != null) {
            String message3 = JavaErrorMessages.message("module.conflicting.packages", packageName, origin.getName());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message3).create();
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileName(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        if (!"module-info.java".equals(file.getName())) {
            String message2 = JavaErrorMessages.message("module.file.wrong.name", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createRenameFileFix("module-info.java"));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileDuplicates(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        Project project;
        Collection others;
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (module != null && (others = FilenameIndex.getVirtualFilesByName((Project)(project = file.getProject()), (String)"module-info.java", (GlobalSearchScope)module.getModuleScope())).size() > 1) {
            String message2 = JavaErrorMessages.message("module.file.duplicate", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message2).create();
            others.stream().map(f -> PsiManager.getInstance((Project)project).findFile(f)).filter(f -> f != file).findFirst().ifPresent(duplicate -> QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new GoToSymbolFix((NavigatablePsiElement)duplicate, JavaErrorMessages.message("module.open.duplicate.text", new Object[0]))));
            return info;
        }
        return null;
    }

    @NotNull
    static List<HighlightInfo> checkDuplicateStatements(@NotNull PsiJavaModule module) {
        List results = ContainerUtil.newSmartList();
        ModuleHighlightUtil.checkDuplicateRefs(module.getRequires(), st -> st.getModuleName(), "module.duplicate.requires", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getExports(), st -> st.getPackageName(), "module.duplicate.exports", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getOpens(), st -> st.getPackageName(), "module.duplicate.opens", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getUses(), st -> ModuleHighlightUtil.qName(st.getClassReference()), "module.duplicate.uses", results);
        ModuleHighlightUtil.checkDuplicateRefs(module.getProvides(), st -> ModuleHighlightUtil.qName(st.getInterfaceReference()), "module.duplicate.provides", results);
        return results;
    }

    private static <T extends PsiStatement> void checkDuplicateRefs(Iterable<? extends T> statements, Function<? super T, String> ref, @PropertyKey(resourceBundle="messages.JavaErrorMessages") String key2, List<? super HighlightInfo> results) {
        THashSet filter = ContainerUtil.newTroveSet();
        for (PsiStatement statement : statements) {
            String refText = ref.apply(statement);
            if (refText == null || filter.add(refText)) continue;
            String message2 = JavaErrorMessages.message(key2, refText);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)statement));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)MergeModuleStatementsFix.createFix((PsiElement)statement));
            results.add((HighlightInfo)info);
        }
    }

    @NotNull
    static List<HighlightInfo> checkUnusedServices(@NotNull PsiJavaModule module, @NotNull PsiFile file) {
        List provides;
        List results = ContainerUtil.newSmartList();
        Module host = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (host != null && !(provides = JBIterable.from((Iterable)module.getProvides()).toList()).isEmpty()) {
            Set exports = JBIterable.from((Iterable)module.getExports()).map(PsiPackageAccessibilityStatement::getPackageName).filter(Objects::nonNull).toSet();
            Set uses = JBIterable.from((Iterable)module.getUses()).map(st -> ModuleHighlightUtil.qName(st.getClassReference())).filter(Objects::nonNull).toSet();
            for (PsiProvidesStatement statement : provides) {
                String className;
                String packageName;
                PsiElement target;
                PsiJavaCodeReferenceElement ref = statement.getInterfaceReference();
                if (ref == null || !((target = ref.resolve()) instanceof PsiClass) || ModuleUtilCore.findModuleForFile((PsiFile)target.getContainingFile()) != host || exports.contains(packageName = StringUtil.getPackageName((String)(className = ModuleHighlightUtil.qName(ref)))) || uses.contains(className)) continue;
                String message2 = JavaErrorMessages.message("module.service.unused", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(ref)).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new AddExportsDirectiveFix(module, packageName, ""));
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new AddUsesDirectiveFix(module, className));
                results.add(info);
            }
        }
        return results;
    }

    private static String qName(PsiJavaCodeReferenceElement ref) {
        return ref != null ? ref.getQualifiedName() : null;
    }

    @Nullable
    static HighlightInfo checkFileLocation(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        VirtualFile root;
        VirtualFile vFile = file.getVirtualFile();
        if (vFile != null && (root = ProjectFileIndex.SERVICE.getInstance((Project)file.getProject()).getSourceRootForFile(vFile)) != null && !root.equals(vFile.getParent())) {
            String message2 = JavaErrorMessages.message("module.file.wrong.location", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new MoveFileFix(vFile, root, QuickFixBundle.message("move.file.to.source.root.text", new Object[0])));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkModuleReference(@NotNull PsiRequiresStatement statement) {
        PsiJavaModuleReferenceElement refElement = statement.getReferenceElement();
        if (refElement != null) {
            PsiJavaModuleReference ref = refElement.getReference();
            assert (ref != null) : refElement.getParent();
            PsiJavaModule target = ref.resolve();
            if (target == null) {
                if (ref.multiResolve(true).length == 0) {
                    String message2 = JavaErrorMessages.message("module.not.found", refElement.getReferenceText());
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
                }
                if (ref.multiResolve(false).length > 1) {
                    String message3 = JavaErrorMessages.message("module.ambiguous", refElement.getReferenceText());
                    return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range((PsiElement)refElement).descriptionAndTooltip(message3).create();
                }
                String message4 = JavaErrorMessages.message("module.not.on.path", refElement.getReferenceText());
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range((PsiElement)refElement).descriptionAndTooltip(message4).create();
                ModuleHighlightUtil.factory().registerOrderEntryFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info), (PsiReference)ref);
                return info;
            }
            PsiJavaModule container = (PsiJavaModule)statement.getParent();
            if (target == container) {
                String message5 = JavaErrorMessages.message("module.cyclic.dependence", container.getName());
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)refElement).descriptionAndTooltip(message5).create();
            }
            Collection<PsiJavaModule> cycle = JavaModuleGraphUtil.findCycle(target);
            if (cycle != null && cycle.contains(container)) {
                Stream<String> stream = cycle.stream().map(PsiJavaModule::getName);
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    stream = stream.sorted();
                }
                String message6 = JavaErrorMessages.message("module.cyclic.dependence", stream.collect(Collectors.joining(", ")));
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)refElement).descriptionAndTooltip(message6).create();
            }
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkHostModuleStrength(@NotNull PsiPackageAccessibilityStatement statement) {
        PsiElement parent;
        if (statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS && (parent = statement.getParent()) instanceof PsiJavaModule && ((PsiJavaModule)parent).hasModifierProperty("open")) {
            String message2 = JavaErrorMessages.message("module.opens.in.weak.module", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)statement).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createModifierListFix((PsiModifierListOwner)parent, "open", false, false));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix((PsiElement)statement));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkPackageReference(@NotNull PsiPackageAccessibilityStatement statement, @NotNull PsiFile file) {
        Module module;
        PsiJavaCodeReferenceElement refElement = statement.getPackageReference();
        if (refElement != null && (module = ModuleUtilCore.findModuleForFile((PsiFile)file)) != null) {
            HighlightInfoType type2;
            PsiElement target = refElement.resolve();
            PsiDirectory[] directories = PsiDirectory.EMPTY_ARRAY;
            if (target instanceof PsiPackage) {
                boolean inTests = ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(file.getVirtualFile());
                directories = ((PsiPackage)target).getDirectories(module.getModuleScope(inTests));
            }
            String packageName = statement.getPackageName();
            boolean opens = statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS;
            HighlightInfoType highlightInfoType = type2 = opens ? HighlightInfoType.WARNING : HighlightInfoType.ERROR;
            if (directories.length == 0) {
                String message2 = JavaErrorMessages.message("package.not.found", packageName);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)type2).range((PsiElement)refElement).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createCreateClassInPackageInModuleFix(module, packageName));
                return info;
            }
            if (packageName != null && ModuleHighlightUtil.isPackageEmpty(directories, packageName, opens)) {
                String message3 = JavaErrorMessages.message("package.is.empty", packageName);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)type2).range((PsiElement)refElement).descriptionAndTooltip(message3).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createCreateClassInPackageInModuleFix(module, packageName));
                return info;
            }
        }
        return null;
    }

    private static boolean isPackageEmpty(PsiDirectory[] directories, String packageName, boolean anyFile) {
        if (anyFile) {
            return Arrays.stream(directories).noneMatch(dir -> dir.getFiles().length > 0);
        }
        return PsiUtil.isPackageEmpty((PsiDirectory[])directories, (String)packageName);
    }

    @NotNull
    static List<HighlightInfo> checkPackageAccessTargets(@NotNull PsiPackageAccessibilityStatement statement) {
        List results = ContainerUtil.newSmartList();
        THashSet targets = ContainerUtil.newTroveSet();
        for (PsiJavaModuleReferenceElement refElement : statement.getModuleReferences()) {
            String refText = refElement.getReferenceText();
            PsiJavaModuleReference ref = refElement.getReference();
            assert (ref != null) : statement;
            if (!targets.add(refText)) {
                boolean exports = statement.getRole() == PsiPackageAccessibilityStatement.Role.EXPORTS;
                String message2 = JavaErrorMessages.message(exports ? "module.duplicate.exports.target" : "module.duplicate.opens.target", refText);
                HighlightInfo info = ModuleHighlightUtil.duplicateReference((PsiElement)refElement, message2);
                results.add(info);
                continue;
            }
            if (ref.multiResolve(true).length != 0) continue;
            String message3 = JavaErrorMessages.message("module.not.found", refElement.getReferenceText());
            results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range((PsiElement)refElement).descriptionAndTooltip(message3).create());
        }
        return results;
    }

    @Nullable
    static HighlightInfo checkServiceReference(@Nullable PsiJavaCodeReferenceElement refElement) {
        if (refElement != null) {
            PsiElement target = refElement.resolve();
            if (!(target instanceof PsiClass)) {
                String message2 = JavaErrorMessages.message("cannot.resolve.symbol", refElement.getReferenceName());
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).descriptionAndTooltip(message2).create();
            }
            if (((PsiClass)target).isEnum()) {
                String message3 = JavaErrorMessages.message("module.service.enum", ((PsiClass)target).getName());
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(refElement)).descriptionAndTooltip(message3).create();
            }
        }
        return null;
    }

    @Nullable
    static List<HighlightInfo> checkServiceImplementations(@NotNull PsiProvidesStatement statement, @NotNull PsiFile file) {
        PsiReferenceList implRefList = statement.getImplementationList();
        if (implRefList == null) {
            return null;
        }
        List results = ContainerUtil.newSmartList();
        PsiJavaCodeReferenceElement intRef = statement.getInterfaceReference();
        PsiElement intTarget = intRef != null ? intRef.resolve() : null;
        THashSet filter = ContainerUtil.newTroveSet();
        for (PsiJavaCodeReferenceElement implRef : implRefList.getReferenceElements()) {
            String message2;
            PsiMethod provider;
            PsiElement implTarget;
            String refText = implRef.getQualifiedName();
            if (!filter.add(refText)) {
                String message3 = JavaErrorMessages.message("module.duplicate.impl", refText);
                HighlightInfo info = ModuleHighlightUtil.duplicateReference((PsiElement)implRef, message3);
                results.add(info);
                continue;
            }
            if (!(intTarget instanceof PsiClass) || !((implTarget = implRef.resolve()) instanceof PsiClass)) continue;
            PsiClass implClass = (PsiClass)implTarget;
            if (ModuleUtilCore.findModuleForFile((PsiFile)file) != ModuleUtilCore.findModuleForFile((PsiFile)implClass.getContainingFile())) {
                String message4 = JavaErrorMessages.message("module.service.alien", new Object[0]);
                results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message4).create());
            }
            if ((provider = (PsiMethod)ContainerUtil.find((Object[])implClass.findMethodsByName("provider", false), m -> m.hasModifierProperty("public") && m.hasModifierProperty("static") && m.getParameterList().isEmpty())) != null) {
                PsiClass typeClass;
                PsiType type2 = provider.getReturnType();
                PsiClass psiClass = typeClass = type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)typeClass, (PsiClass)((PsiClass)intTarget), (boolean)true)) continue;
                String message5 = JavaErrorMessages.message("module.service.provider.type", implClass.getName());
                results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message5).create());
                continue;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)implClass, (PsiClass)((PsiClass)intTarget), (boolean)true)) {
                if (implClass.hasModifierProperty("abstract")) {
                    message2 = JavaErrorMessages.message("module.service.abstract", implClass.getName());
                    results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
                    continue;
                }
                if (!ClassUtil.isTopLevelClass((PsiClass)implClass) && !implClass.hasModifierProperty("static")) {
                    message2 = JavaErrorMessages.message("module.service.inner", implClass.getName());
                    results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
                    continue;
                }
                if (PsiUtil.hasDefaultConstructor((PsiClass)implClass)) continue;
                message2 = JavaErrorMessages.message("module.service.no.ctor", implClass.getName());
                results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
                continue;
            }
            message2 = JavaErrorMessages.message("module.service.impl", new Object[0]);
            results.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(implRef)).descriptionAndTooltip(message2).create());
        }
        return results;
    }

    @Nullable
    static HighlightInfo checkClashingReads(@NotNull PsiJavaModule module) {
        Trinity<String, PsiJavaModule, PsiJavaModule> conflict = JavaModuleGraphUtil.findConflict(module);
        if (conflict != null) {
            String message2 = JavaErrorMessages.message("module.conflicting.reads", module.getName(), conflict.first, ((PsiJavaModule)conflict.second).getName(), ((PsiJavaModule)conflict.third).getName());
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(module)).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    @Nullable
    static List<HighlightInfo> checkModifiers(@NotNull PsiRequiresStatement statement) {
        PsiModifierList modList = statement.getModifierList();
        if (modList != null && "java.base".equals(statement.getModuleName())) {
            return SyntaxTraverser.psiTraverser().children((Object)modList).filter(PsiKeyword.class).map(keyword -> {
                String modifier = keyword.getText();
                String message2 = JavaErrorMessages.message("modifier.not.allowed", modifier);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)keyword).descriptionAndTooltip(message2).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createModifierListFix(modList, modifier, false, false));
                return info;
            }).toList();
        }
        return null;
    }

    private static QuickFixFactory factory() {
        return QuickFixFactory.getInstance();
    }

    private static TextRange range(PsiJavaModule module) {
        PsiKeyword kw = (PsiKeyword)PsiTreeUtil.getChildOfType((PsiElement)module, PsiKeyword.class);
        return new TextRange(kw != null ? kw.getTextOffset() : module.getTextOffset(), module.getNameIdentifier().getTextRange().getEndOffset());
    }

    private static PsiElement range(PsiJavaCodeReferenceElement refElement) {
        return (PsiElement)ObjectUtils.notNull((Object)refElement.getReferenceNameElement(), (Object)refElement);
    }

    private static HighlightInfo duplicateReference(PsiElement refElement, String message2) {
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(refElement).descriptionAndTooltip(message2).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)ModuleHighlightUtil.factory().createDeleteFix(refElement, QuickFixBundle.message("delete.reference.fix.text", new Object[0])));
        return info;
    }
}

