/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RefCountHolder {
    private final PsiFile myFile;
    private final MultiMap<PsiElement, PsiReference> myLocalRefsMap = MultiMap.createSet();
    private final Map<PsiAnchor, Boolean> myDclsUsedMap = new THashMap();
    private final Map<PsiReference, PsiImportStatementBase> myImportStatements = new THashMap();
    private final AtomicReference<ProgressIndicator> myState = new AtomicReference<ProgressIndicator>(EMPTY);
    private static final ProgressIndicator READY = new DaemonProgressIndicator(){
        {
            this.cancel();
        }

        public String toString() {
            return "READY";
        }
    };
    private static final ProgressIndicator EMPTY = new DaemonProgressIndicator(){
        {
            this.cancel();
        }

        public String toString() {
            return "EMPTY";
        }
    };
    private static final Key<Reference<RefCountHolder>> REF_COUNT_HOLDER_IN_FILE_KEY = Key.create((String)"REF_COUNT_HOLDER_IN_FILE_KEY");

    @NotNull
    static RefCountHolder get(@NotNull PsiFile file) {
        Reference ref = (Reference)file.getUserData(REF_COUNT_HOLDER_IN_FILE_KEY);
        RefCountHolder holder = (RefCountHolder)SoftReference.dereference((Reference)ref);
        if (holder == null) {
            boolean replaced;
            holder = new RefCountHolder(file);
            java.lang.ref.SoftReference<RefCountHolder> newRef = new java.lang.ref.SoftReference<RefCountHolder>(holder);
            while (!(replaced = ((UserDataHolderEx)file).replace(REF_COUNT_HOLDER_IN_FILE_KEY, (Object)ref, newRef))) {
                ref = (Reference)file.getUserData(REF_COUNT_HOLDER_IN_FILE_KEY);
                RefCountHolder newHolder = (RefCountHolder)SoftReference.dereference((Reference)ref);
                if (newHolder == null) continue;
                holder = newHolder;
                break;
            }
        }
        return holder;
    }

    private RefCountHolder(@NotNull PsiFile file) {
        this.myFile = file;
        RefCountHolder.log("c: created for ", file);
    }

    @NotNull
    GlobalUsageHelper getGlobalUsageHelper(@NotNull PsiFile file, final @Nullable UnusedDeclarationInspectionBase deadCodeInspection, boolean isUnusedToolEnabled) {
        boolean isDeadCodeEnabled;
        FileViewProvider viewProvider = file.getViewProvider();
        Project project = file.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        boolean inLibrary = fileIndex.isInLibrary(virtualFile);
        boolean bl = isDeadCodeEnabled = deadCodeInspection != null && isUnusedToolEnabled && deadCodeInspection.isGlobalEnabledInEditor();
        if (isDeadCodeEnabled && !inLibrary) {
            return new GlobalUsageHelperBase(){
                Map<PsiMember, Boolean> myEntryPointCache = FactoryMap.create(member -> {
                    if (this.isEntryPoint((PsiElement)member)) {
                        return true;
                    }
                    if (member instanceof PsiClass) {
                        return !((JBTreeTraverser)JBTreeTraverser.from(m -> m instanceof PsiClass ? JBIterable.from((Iterable)PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)m, PsiMember.class)) : JBIterable.empty()).withRoot(member)).traverse().skip(1).processEach(m -> this.myEntryPointCache.get(m) == false);
                    }
                    return false;
                });

                @Override
                public boolean shouldCheckUsages(@NotNull PsiMember member) {
                    return this.myEntryPointCache.get(member) == false;
                }

                private boolean isEntryPoint(@NotNull PsiElement element) {
                    return deadCodeInspection.isEntryPoint(element);
                }
            };
        }
        return new GlobalUsageHelperBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            this.myLocalRefsMap.clear();
        }
        this.myImportStatements.clear();
        this.myDclsUsedMap.clear();
    }

    void registerLocallyReferenced(@NotNull PsiNamedElement result) {
        this.myDclsUsedMap.put(PsiAnchor.create((PsiElement)result), Boolean.TRUE);
    }

    void registerReference(@NotNull PsiReference ref, @NotNull JavaResolveResult resolveResult) {
        PsiElement resolveScope;
        PsiFile psiFile;
        PsiElement refElement = resolveResult.getElement();
        PsiFile psiFile2 = psiFile = refElement == null ? null : refElement.getContainingFile();
        if (psiFile != null) {
            psiFile = (PsiFile)psiFile.getNavigationElement();
        }
        if (refElement != null && psiFile != null && this.myFile.getViewProvider().equals(psiFile.getViewProvider())) {
            this.registerLocalRef(ref, refElement.getNavigationElement());
        }
        if ((resolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) {
            this.registerImportStatement(ref, (PsiImportStatementBase)resolveScope);
        } else if (refElement == null && ref instanceof PsiJavaReference) {
            for (JavaResolveResult result : ((PsiJavaReference)ref).multiResolve(true)) {
                resolveScope = result.getCurrentFileResolveScope();
                if (!(resolveScope instanceof PsiImportStatementBase)) continue;
                this.registerImportStatement(ref, (PsiImportStatementBase)resolveScope);
                break;
            }
        }
    }

    private void registerImportStatement(@NotNull PsiReference ref, @NotNull PsiImportStatementBase importStatement) {
        this.myImportStatements.put(ref, importStatement);
    }

    boolean isRedundant(@NotNull PsiImportStatementBase importStatement) {
        return !this.myImportStatements.containsValue(importStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLocalRef(@NotNull PsiReference ref, PsiElement refElement) {
        PsiElement element = ref.getElement();
        if (refElement instanceof PsiMethod && PsiTreeUtil.isAncestor((PsiElement)refElement, (PsiElement)element, (boolean)true)) {
            return;
        }
        if (refElement instanceof PsiClass) {
            PsiElement resolve;
            if (PsiTreeUtil.isAncestor((PsiElement)refElement, (PsiElement)element, (boolean)true)) {
                return;
            }
            PsiImportStatementBase importStmt = (PsiImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatementBase.class);
            if (importStmt != null && (resolve = importStmt.resolve()) != null && PsiTreeUtil.isAncestor((PsiElement)refElement, (PsiElement)resolve, (boolean)false)) {
                return;
            }
        }
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            this.myLocalRefsMap.putValue((Object)refElement, (Object)ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidRefs() {
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            ArrayList<Pair> toRemove2 = new ArrayList<Pair>();
            for (Map.Entry entry : this.myLocalRefsMap.entrySet()) {
                PsiElement element = (PsiElement)entry.getKey();
                for (PsiReference ref2 : (Collection)entry.getValue()) {
                    if (ref2.getElement().isValid()) continue;
                    toRemove2.add(Pair.create((Object)element, (Object)ref2));
                }
            }
            for (Pair pair : toRemove2) {
                this.myLocalRefsMap.remove(pair.first, pair.second);
            }
        }
        this.myImportStatements.keySet().removeIf(ref -> !ref.getElement().isValid());
        RefCountHolder.removeInvalidFrom(this.myDclsUsedMap.keySet());
    }

    private static void removeInvalidFrom(@NotNull Collection<? extends PsiAnchor> collection) {
        collection.removeIf(element -> element.retrieve() == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReferenced(@NotNull PsiElement element) {
        Boolean usedStatus;
        Collection array;
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            array = this.myLocalRefsMap.get((Object)element);
        }
        if (!array.isEmpty() && !RefCountHolder.isParameterUsedRecursively(element, array)) {
            for (PsiReference reference : array) {
                if (!reference.isReferenceTo(element)) continue;
                return true;
            }
        }
        return (usedStatus = this.myDclsUsedMap.get(PsiAnchor.create((PsiElement)element))) == Boolean.TRUE;
    }

    private static boolean isParameterUsedRecursively(@NotNull PsiElement element, @NotNull Collection<? extends PsiReference> array) {
        if (!(element instanceof PsiParameter)) {
            return false;
        }
        PsiParameter parameter2 = (PsiParameter)element;
        PsiElement scope = parameter2.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)scope;
        int paramIndex = ArrayUtilRt.find((Object[])method.getParameterList().getParameters(), (Object)parameter2);
        for (PsiReference psiReference : array) {
            if (!(psiReference instanceof PsiElement)) {
                return false;
            }
            PsiElement argument = (PsiElement)psiReference;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)new PsiMatcherImpl(argument).dot(PsiMatchers.hasClass(PsiReferenceExpression.class)).parent(PsiMatchers.hasClass(PsiExpressionList.class)).parent(PsiMatchers.hasClass(PsiMethodCallExpression.class)).getElement();
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            if (method != methodExpression.resolve()) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            Object[] arguments = argumentList.getExpressions();
            int argumentIndex = ArrayUtilRt.find((Object[])arguments, (Object)argument);
            if (paramIndex == argumentIndex) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReferencedForRead(@NotNull PsiVariable variable) {
        Collection array;
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            array = this.myLocalRefsMap.get((Object)variable);
        }
        if (array.isEmpty()) {
            return false;
        }
        for (PsiReference ref : array) {
            ReadWriteAccessDetector.Access access;
            PsiElement refElement = ref.getElement();
            PsiElement resolved = ref.resolve();
            if (resolved == null || (access = RefCountHolder.getAccess(ref, resolved)) != ReadWriteAccessDetector.Access.Read && access != ReadWriteAccessDetector.Access.ReadWrite || RefCountHolder.isJustIncremented(access, refElement)) continue;
            return true;
        }
        return false;
    }

    private static ReadWriteAccessDetector.Access getAccess(@NotNull PsiReference ref, @NotNull PsiElement resolved) {
        PsiElement start = resolved.getLanguage() == ref.getElement().getLanguage() ? resolved : ref.getElement();
        ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector((PsiElement)start);
        if (detector != null) {
            return detector.getReferenceAccess(resolved, ref);
        }
        return null;
    }

    private static boolean isJustIncremented(@NotNull ReadWriteAccessDetector.Access access, @NotNull PsiElement refElement) {
        return access == ReadWriteAccessDetector.Access.ReadWrite && refElement instanceof PsiExpression && refElement.getParent() instanceof PsiExpression && refElement.getParent().getParent() instanceof PsiExpressionStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReferencedForWrite(@NotNull PsiVariable variable) {
        Collection array;
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            array = this.myLocalRefsMap.get((Object)variable);
        }
        if (array.isEmpty()) {
            return false;
        }
        for (PsiReference ref : array) {
            ReadWriteAccessDetector.Access access;
            PsiElement resolved = ref.resolve();
            if (resolved == null || (access = RefCountHolder.getAccess(ref, resolved)) != ReadWriteAccessDetector.Access.Write && access != ReadWriteAccessDetector.Access.ReadWrite) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean analyze(@NotNull PsiFile file, TextRange dirtyScope, @NotNull ProgressIndicator indicator, @NotNull Runnable analyze) {
        boolean bl;
        ProgressIndicator result;
        block11: {
            if (this.myState.compareAndSet(EMPTY, indicator)) {
                if (!file.getTextRange().equals((Object)dirtyScope)) {
                    RefCountHolder.log(" RefCountHolder: invalid scope " + dirtyScope);
                    this.myState.set(EMPTY);
                    return false;
                }
                result = EMPTY;
            } else if (this.myState.compareAndSet(READY, indicator)) {
                result = READY;
            } else {
                RefCountHolder.log("a: failed to change ", this.myState, "->", indicator);
                return false;
            }
            try {
                RefCountHolder.log("a: changed ", this.myState, "->", indicator);
                if (dirtyScope != null) {
                    if (dirtyScope.equals((Object)file.getTextRange())) {
                        this.clear();
                    } else {
                        this.removeInvalidRefs();
                    }
                }
                analyze.run();
                result = READY;
                bl = true;
                boolean set = this.myState.compareAndSet(indicator, result);
                if ($assertionsDisabled || set) break block11;
            }
            catch (Throwable throwable) {
                boolean set = this.myState.compareAndSet(indicator, result);
                assert (set) : this.myState.get();
                RefCountHolder.log("a: changed after analyze", indicator, "->", result);
                throw throwable;
            }
            throw new AssertionError(this.myState.get());
        }
        RefCountHolder.log("a: changed after analyze", indicator, "->", result);
        return bl;
    }

    private static void log(Object ... info) {
        FileStatusMap.log((Object[])info);
    }

    private class GlobalUsageHelperBase
    extends GlobalUsageHelper {
        private GlobalUsageHelperBase() {
        }

        @Override
        public boolean shouldCheckUsages(@NotNull PsiMember member) {
            return false;
        }

        @Override
        public boolean isCurrentFileAlreadyChecked() {
            return true;
        }

        @Override
        public boolean isLocallyUsed(@NotNull PsiNamedElement member) {
            return RefCountHolder.this.isReferenced((PsiElement)member);
        }
    }
}

