/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SideEffectWarningDialog;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessStaticViaInstanceFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AccessStaticViaInstanceFix");
    private final boolean myOnTheFly;
    private final String myText;

    public AccessStaticViaInstanceFix(@NotNull PsiReferenceExpression expression2, @NotNull JavaResolveResult result, boolean onTheFly) {
        super((PsiElement)expression2);
        this.myOnTheFly = onTheFly;
        PsiMember member = (PsiMember)result.getElement();
        this.myText = AccessStaticViaInstanceFix.calcText(member, result.getSubstitutor());
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    private static String calcText(PsiMember member, PsiSubstitutor substitutor) {
        PsiClass aClass = member.getContainingClass();
        if (aClass == null) {
            return "";
        }
        return QuickFixBundle.message("access.static.via.class.reference.text", HighlightMessageUtil.getSymbolName((PsiElement)member, substitutor, 2), HighlightUtil.formatClass(aClass, false), HighlightUtil.formatClass(aClass, false));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("access.static.via.class.reference.family", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiReferenceExpression myExpression = (PsiReferenceExpression)startElement;
        if (!myExpression.isValid()) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(myExpression.getContainingFile())) {
            return;
        }
        PsiElement element = myExpression.resolve();
        if (!(element instanceof PsiMember)) {
            return;
        }
        PsiMember myMember = (PsiMember)element;
        if (!myMember.isValid()) {
            return;
        }
        PsiClass containingClass = myMember.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiExpression qualifierExpression2 = myExpression.getQualifierExpression();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        if (qualifierExpression2 != null && !this.checkSideEffects(project, containingClass, qualifierExpression2, factory, (PsiElement)myExpression, editor)) {
            return;
        }
        WriteAction.run(() -> {
            try {
                PsiReferenceExpression newQualifier = factory.createReferenceExpression(containingClass);
                if (qualifierExpression2 != null) {
                    newQualifier = qualifierExpression2.replace((PsiElement)newQualifier);
                } else {
                    myExpression.setQualifierExpression((PsiExpression)newQualifier);
                    newQualifier = myExpression.getQualifierExpression();
                }
                PsiElement qualifiedWithClassName = myExpression.copy();
                if (myExpression.getTypeParameters().length == 0 && (!containingClass.isInterface() || containingClass.equals(PsiTreeUtil.getParentOfType((PsiElement)myExpression, PsiClass.class)))) {
                    newQualifier.delete();
                    if (myExpression.resolve() != myMember) {
                        myExpression.replace(qualifiedWithClassName);
                    }
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private boolean checkSideEffects(Project project, PsiClass containingClass, final PsiExpression qualifierExpression2, PsiElementFactory factory, final PsiElement myExpression, Editor editor) {
        ArrayList sideEffects = new ArrayList();
        boolean hasSideEffects = RemoveUnusedVariableUtil.checkSideEffects(qualifierExpression2, null, sideEffects);
        if (hasSideEffects && !this.myOnTheFly) {
            return false;
        }
        if (!hasSideEffects || ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (editor == null) {
            return false;
        }
        TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        HighlightManager.getInstance((Project)project).addOccurrenceHighlights(editor, PsiUtilCore.toPsiElementArray(sideEffects), attributes, true, null);
        try {
            hasSideEffects = PsiUtil.isStatement((PsiElement)factory.createStatementFromText(qualifierExpression2.getText(), (PsiElement)qualifierExpression2));
        }
        catch (IncorrectOperationException e) {
            hasSideEffects = false;
        }
        final PsiReferenceExpression qualifiedWithClassName = (PsiReferenceExpression)myExpression.copy();
        qualifiedWithClassName.setQualifierExpression((PsiExpression)factory.createReferenceExpression(containingClass));
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)myExpression, PsiStatement.class);
        final boolean canCopeWithSideEffects = hasSideEffects && statement != null;
        SideEffectWarningDialog dialog = new SideEffectWarningDialog(project, false, null, ((PsiElement)sideEffects.get(0)).getText(), PsiExpressionTrimRenderer.render((PsiExpression)qualifierExpression2), canCopeWithSideEffects){

            @Override
            protected String sideEffectsDescription() {
                if (canCopeWithSideEffects) {
                    return MessageFormat.format(this.getFormatString(), "expression '" + qualifierExpression2.getText() + "'", myExpression.getText(), qualifierExpression2.getText() + ";<br>" + qualifiedWithClassName.getText());
                }
                return "<html><body>  There are possible side effects found in expression '" + qualifierExpression2.getText() + "'<br>You can <b>Remove</b> class reference along with whole expressions involved</body></html>";
            }
        };
        dialog.show();
        int res = dialog.getExitCode();
        if (res == RemoveUnusedVariableUtil.RemoveMode.CANCEL.ordinal()) {
            return false;
        }
        if (res == RemoveUnusedVariableUtil.RemoveMode.MAKE_STATEMENT.ordinal()) {
            PsiStatement statementFromText = factory.createStatementFromText(qualifierExpression2.getText() + ";", null);
            LOG.assertTrue(statement != null);
            WriteAction.run(() -> {
                try {
                    PsiElement parent = statement.getParent();
                    BlockUtils.addBefore(parent instanceof PsiForStatement ? (PsiStatement)parent : statement, statementFromText);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
        }
        return true;
    }
}

