/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.AddMethodFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.VisibilityUtil;
import org.jetbrains.annotations.NotNull;

public class AddDefaultConstructorFix
extends AddMethodFix {
    public AddDefaultConstructorFix(PsiClass aClass) {
        this(aClass, PsiUtil.getMaximumModifierForMember((PsiClass)aClass, (boolean)false));
    }

    public AddDefaultConstructorFix(PsiClass aClass, @NotNull @PsiModifier.ModifierConstant String modifier) {
        super(AddDefaultConstructorFix.generateConstructor(aClass.getName(), modifier), aClass, new String[0]);
        this.setText(QuickFixBundle.message("add.default.constructor.text", VisibilityUtil.toPresentableText((String)modifier), aClass.getName()));
    }

    private static String generateConstructor(String className, @PsiModifier.ModifierConstant String modifier) {
        if (modifier.equals("packageLocal")) {
            return className + "() {}";
        }
        return modifier + " " + className + "() {}";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("add.default.constructor.family", new Object[0]);
    }
}

