/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class AddExtLibraryDependencyFix
extends OrderEntryFix {
    private final Module myCurrentModule;
    private final ExternalLibraryDescriptor myLibraryDescriptor;
    private final DependencyScope myScope;
    private final String myQualifiedClassName;

    AddExtLibraryDependencyFix(PsiReference reference, Module currentModule, ExternalLibraryDescriptor descriptor, DependencyScope scope, String qName) {
        super(reference);
        this.myCurrentModule = currentModule;
        this.myLibraryDescriptor = descriptor;
        this.myScope = scope;
        this.myQualifiedClassName = qName;
    }

    @Nls
    @NotNull
    public String getText() {
        return "Add '" + this.myLibraryDescriptor.getPresentableName() + "' to classpath";
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return !project.isDisposed() && !this.myCurrentModule.isDisposed();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        JavaProjectModelModificationService.getInstance(project).addDependency(this.myCurrentModule, this.myLibraryDescriptor, this.myScope).onSuccess(aVoid -> WriteAction.runAndWait(() -> {
            try {
                AddExtLibraryDependencyFix.importClass(this.myCurrentModule, editor, this.restoreReference(), this.myQualifiedClassName);
            }
            catch (IndexNotReadyException e) {
                Logger.getInstance(AddExtLibraryDependencyFix.class).info((Throwable)e);
            }
        }));
    }
}

