/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.application.options.ModuleListCellRenderer;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.util.PointersKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.modules.CircularModuleDependenciesDetector;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AddModuleDependencyFix
extends OrderEntryFix {
    private final Module myCurrentModule;
    private final Set<Module> myModules;
    private final DependencyScope myScope;
    private final boolean myExported;
    private final List<SmartPsiElementPointer<PsiClass>> myClasses;

    AddModuleDependencyFix(PsiReference reference, Module currentModule, DependencyScope scope, List<? extends PsiClass> classes2) {
        super(reference);
        this.myCurrentModule = currentModule;
        this.myModules = new LinkedHashSet<Module>();
        this.myScope = scope;
        this.myExported = false;
        this.myClasses = ContainerUtil.map(classes2, PointersKt::createSmartPointer);
        PsiElement psiElement = reference.getElement();
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)currentModule);
        for (PsiClass psiClass : classes2) {
            Module classModule;
            if (!AddModuleDependencyFix.isAccessible(psiClass, psiElement) || (classModule = ModuleUtilCore.findModuleForFile((PsiFile)psiClass.getContainingFile())) == null || classModule == currentModule || rootManager.isDependsOn(classModule)) continue;
            this.myModules.add(classModule);
        }
    }

    private static boolean isAccessible(PsiClass aClass, PsiElement refElement) {
        return JavaResolveUtil.isAccessible((PsiMember)aClass, aClass.getContainingClass(), aClass.getModifierList(), refElement, aClass, null);
    }

    AddModuleDependencyFix(PsiJavaModuleReference reference, Module currentModule, Set<Module> modules, DependencyScope scope, boolean exported) {
        super((PsiReference)reference);
        this.myCurrentModule = currentModule;
        this.myModules = modules;
        this.myScope = scope;
        this.myExported = exported;
        this.myClasses = Collections.emptyList();
    }

    @NotNull
    public String getText() {
        if (this.myModules.size() == 1) {
            Module module = (Module)ContainerUtil.getFirstItem(this.myModules);
            assert (module != null);
            return QuickFixBundle.message("orderEntry.fix.add.dependency.on.module", module.getName());
        }
        return QuickFixBundle.message("orderEntry.fix.add.dependency.on.module.choose", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("orderEntry.fix.family.add.module.dependency", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return !project.isDisposed() && !this.myCurrentModule.isDisposed() && !this.myModules.isEmpty() && this.myModules.stream().noneMatch(Module::isDisposed);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
        if (this.myModules.size() == 1) {
            this.addDependencyOnModule(project, editor, (Module)ContainerUtil.getFirstItem(this.myModules));
        } else {
            JBPopup popup = JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList(this.myModules)).setRenderer((ListCellRenderer)new ModuleListCellRenderer()).setTitle(QuickFixBundle.message("orderEntry.fix.choose.module.to.add.dependency.on", new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(selectedValue -> this.addDependencyOnModule(project, editor, (Module)selectedValue)).createPopup();
            if (editor != null) {
                popup.showInBestPositionFor(editor);
            } else {
                popup.showCenteredInCurrentWindow(project);
            }
        }
    }

    private void addDependencyOnModule(Project project, Editor editor, @Nullable Module module) {
        if (module == null) {
            return;
        }
        Couple circularModules = CircularModuleDependenciesDetector.addingDependencyFormsCircularity((Module)this.myCurrentModule, (Module)module);
        if (circularModules == null || AddModuleDependencyFix.showCircularWarning(project, (Couple<Module>)circularModules, module)) {
            PsiReference ref;
            PsiClass[] targetClasses;
            JavaProjectModelModificationService.getInstance(project).addDependency(this.myCurrentModule, module, this.myScope, this.myExported);
            if (editor != null && !this.myClasses.isEmpty() && (targetClasses = (PsiClass[])this.myClasses.stream().map(SmartPsiElementPointer::getElement).filter(c -> c != null && ModuleUtilCore.findModuleForPsiElement((PsiElement)c) == module).toArray(PsiClass[]::new)).length > 0 && (ref = this.restoreReference()) != null) {
                DumbService.getInstance((Project)project).completeJustSubmittedTasks();
                new AddImportAction(project, ref, editor, targetClasses).execute();
            }
        }
    }

    private static boolean showCircularWarning(Project project, Couple<Module> circle, Module classModule) {
        String title;
        String message2 = QuickFixBundle.message("orderEntry.fix.circular.dependency.warning", classModule.getName(), ((Module)circle.getFirst()).getName(), ((Module)circle.getSecond()).getName());
        return Messages.showOkCancelDialog((Project)project, (String)message2, (String)(title = QuickFixBundle.message("orderEntry.fix.title.circular.dependency.warning", new Object[0])), (Icon)Messages.getWarningIcon()) == 0;
    }
}

