/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddVariableInitializerFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.AddReturnFix");
    private final PsiVariable myVariable;

    public AddVariableInitializerFix(@NotNull PsiVariable variable) {
        this.myVariable = variable;
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"quickfix.add.variable.text", (Object[])new Object[]{this.myVariable.getName()});
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"quickfix.add.variable.family.name", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myVariable.isValid() && BaseIntentionAction.canModify((PsiElement)this.myVariable) && !this.myVariable.hasInitializer() && !(this.myVariable instanceof PsiParameter);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.myVariable;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        LookupElement[] suggestedInitializers = AddVariableInitializerFix.suggestInitializer(this.myVariable);
        LOG.assertTrue(suggestedInitializers.length > 0);
        LOG.assertTrue(suggestedInitializers[0] instanceof ExpressionLookupItem);
        PsiExpression initializer = (PsiExpression)suggestedInitializers[0].getObject();
        this.myVariable.setInitializer(initializer);
        Document document = Objects.requireNonNull(PsiDocumentManager.getInstance((Project)project).getDocument(file));
        PsiDocumentManager.getInstance((Project)initializer.getProject()).doPostponedOperationsAndUnblockDocument(document);
        AddVariableInitializerFix.runAssignmentTemplate(Collections.singletonList(this.myVariable.getInitializer()), suggestedInitializers, editor);
    }

    static void runAssignmentTemplate(@NotNull List<? extends PsiExpression> initializers, final @NotNull LookupElement[] suggestedInitializers, @Nullable Editor editor) {
        if (editor == null) {
            return;
        }
        LOG.assertTrue(!initializers.isEmpty());
        PsiExpression initializer = (PsiExpression)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem(initializers));
        PsiExpression context = initializers.size() == 1 ? initializer : PsiTreeUtil.findCommonParent(initializers);
        TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)context);
        for (PsiExpression psiExpression : initializers) {
            builder.replaceElement((PsiElement)psiExpression, new Expression(){

                @NotNull
                public Result calculateResult(ExpressionContext context1) {
                    return this.calculateQuickResult(context1);
                }

                @NotNull
                public Result calculateQuickResult(ExpressionContext context1) {
                    return new PsiElementResult(suggestedInitializers[0].getPsiElement());
                }

                @NotNull
                public LookupElement[] calculateLookupItems(ExpressionContext context1) {
                    return suggestedInitializers;
                }
            });
        }
        builder.run(editor, false);
    }

    @NotNull
    static LookupElement[] suggestInitializer(PsiVariable variable) {
        PsiType type2 = variable.getType();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
        SmartList result = new SmartList();
        String defaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
        ExpressionLookupItem defaultExpression = new ExpressionLookupItem(elementFactory.createExpressionFromText(defaultValue, (PsiElement)variable));
        result.add(defaultExpression);
        if (type2 instanceof PsiClassType) {
            PsiClass aClass;
            if (type2.equalsToText("java.lang.String")) {
                result.add(new ExpressionLookupItem(elementFactory.createExpressionFromText("\"\"", (PsiElement)variable)));
            }
            if ((aClass = PsiTypesUtil.getPsiClass((PsiType)type2)) != null && !aClass.hasModifierProperty("abstract") && PsiUtil.hasDefaultConstructor((PsiClass)aClass)) {
                String typeText = type2.getCanonicalText(false);
                if (aClass.getTypeParameters().length > 0 && PsiUtil.isLanguageLevel7OrHigher((PsiElement)variable) && !PsiDiamondTypeImpl.haveConstructorsGenericsParameters(aClass)) {
                    typeText = TypeConversionUtil.erasure((PsiType)type2).getCanonicalText(false) + "<>";
                }
                String expressionText = "new " + typeText + "()";
                PsiExpression initializer = elementFactory.createExpressionFromText(expressionText, (PsiElement)variable);
                String variableName = variable.getName();
                LOG.assertTrue(variableName != null);
                PsiDeclarationStatement statement = elementFactory.createVariableDeclarationStatement(variableName, variable.getType(), initializer, (PsiElement)variable);
                ExpressionLookupItem newExpression = new ExpressionLookupItem(((PsiLocalVariable)statement.getDeclaredElements()[0]).getInitializer());
                result.add(newExpression);
            }
        }
        return result.toArray(LookupElement.EMPTY_ARRAY);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

