/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.JavaTargetElementEvaluator;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.diagnostic.PluginException;
import com.intellij.find.FindManager;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeMethodSignatureFromUsageFix
implements IntentionAction {
    final PsiMethod myTargetMethod;
    final PsiExpression[] myExpressions;
    final PsiSubstitutor mySubstitutor;
    final PsiElement myContext;
    private final boolean myChangeAllUsages;
    private final int myMinUsagesNumberToShowDialog;
    ParameterInfoImpl[] myNewParametersInfo;
    private String myShortName;
    private static final Logger LOG = Logger.getInstance(ChangeMethodSignatureFromUsageFix.class);

    public ChangeMethodSignatureFromUsageFix(@NotNull PsiMethod targetMethod, @NotNull PsiExpression[] expressions2, @NotNull PsiSubstitutor substitutor, @NotNull PsiElement context, boolean changeAllUsages, int minUsagesNumberToShowDialog) {
        this.myTargetMethod = targetMethod;
        this.myExpressions = expressions2;
        this.mySubstitutor = substitutor;
        this.myContext = context;
        this.myChangeAllUsages = changeAllUsages;
        this.myMinUsagesNumberToShowDialog = minUsagesNumberToShowDialog;
    }

    @NotNull
    public String getText() {
        String shortText = this.myShortName;
        if (shortText != null) {
            return shortText;
        }
        return QuickFixBundle.message("change.method.signature.from.usage.text", JavaHighlightUtil.formatMethod(this.myTargetMethod), this.myTargetMethod.getName(), ChangeMethodSignatureFromUsageFix.formatTypesList(this.myNewParametersInfo, this.myContext));
    }

    private String getShortText(StringBuilder buf, HashSet<? extends ParameterInfoImpl> newParams, HashSet<? extends ParameterInfoImpl> removedParams, HashSet<? extends ParameterInfoImpl> changedParams) {
        String targetMethodName = this.myTargetMethod.getName();
        if (this.myTargetMethod.getContainingClass().findMethodsByName(targetMethodName, true).length == 1) {
            if (newParams.size() == 1) {
                ParameterInfoImpl p = newParams.iterator().next();
                return QuickFixBundle.message("add.parameter.from.usage.text", p.getTypeText(), ArrayUtil.find((Object[])this.myNewParametersInfo, (Object)p) + 1, targetMethodName);
            }
            if (removedParams.size() == 1) {
                ParameterInfoImpl p = removedParams.iterator().next();
                return QuickFixBundle.message("remove.parameter.from.usage.text", p.getOldIndex() + 1, targetMethodName);
            }
            if (changedParams.size() == 1) {
                ParameterInfoImpl p = changedParams.iterator().next();
                return QuickFixBundle.message("change.parameter.from.usage.text", p.getOldIndex() + 1, targetMethodName, this.myTargetMethod.getParameterList().getParameters()[p.getOldIndex()].getType().getPresentableText(), p.getTypeText());
            }
        }
        return "<html> Change signature of " + targetMethodName + "(" + buf.toString() + ")</html>";
    }

    @Nullable
    private static String formatTypesList(ParameterInfoImpl[] infos, PsiElement context) {
        if (infos == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        try {
            for (ParameterInfoImpl info : infos) {
                PsiType type2 = info.createType(context);
                if (type2 == null) {
                    return null;
                }
                if (result.length() != 0) {
                    result.append(", ");
                }
                result.append(type2.getPresentableText());
            }
            return result.toString();
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("change.method.signature.from.usage.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!this.myTargetMethod.isValid() || this.myTargetMethod.getContainingClass() == null) {
            return false;
        }
        for (PsiExpression expression2 : this.myExpressions) {
            if (expression2.isValid()) continue;
            return false;
        }
        if (!this.mySubstitutor.isValid()) {
            return false;
        }
        StringBuilder buf = new StringBuilder();
        HashSet newParams = new HashSet();
        HashSet removedParams = new HashSet();
        HashSet changedParams = new HashSet();
        this.myNewParametersInfo = this.getNewParametersInfo(this.myExpressions, this.myTargetMethod, this.mySubstitutor, buf, newParams, removedParams, changedParams);
        if (this.myNewParametersInfo == null || ChangeMethodSignatureFromUsageFix.formatTypesList(this.myNewParametersInfo, this.myContext) == null) {
            return false;
        }
        this.myShortName = this.getShortText(buf, newParams, removedParams, changedParams);
        return !this.isMethodSignatureExists();
    }

    public boolean isMethodSignatureExists() {
        PsiMethod[] methods;
        PsiClass target = this.myTargetMethod.getContainingClass();
        LOG.assertTrue(target != null);
        for (PsiMethod method : methods = target.findMethodsByName(this.myTargetMethod.getName(), false)) {
            if (!PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (PsiExpression[])this.myExpressions)) continue;
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiMethod method = SuperMethodWarningUtil.checkSuperMethod(this.myTargetMethod, RefactoringBundle.message((String)"to.refactor"));
        if (method == null) {
            return;
        }
        this.myNewParametersInfo = this.getNewParametersInfo(this.myExpressions, this.myTargetMethod, this.mySubstitutor);
        List<ParameterInfoImpl> parameterInfos = ChangeMethodSignatureFromUsageFix.performChange(project, editor, file, method, this.myMinUsagesNumberToShowDialog, this.myNewParametersInfo, this.myChangeAllUsages, false, null);
        if (parameterInfos != null) {
            this.myNewParametersInfo = parameterInfos.toArray(new ParameterInfoImpl[0]);
        }
    }

    static List<ParameterInfoImpl> performChange(@NotNull Project project, Editor editor, PsiFile file, @NotNull PsiMethod method, int minUsagesNumber, final ParameterInfoImpl[] newParametersInfo, final boolean changeAllUsages, boolean allowDelegation, final @Nullable Consumer<? super List<ParameterInfoImpl>> callback) {
        if (!FileModificationService.getInstance().prepareFileForWrite(method.getContainingFile())) {
            return null;
        }
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project)).getFindUsagesManager();
        FindUsagesHandler handler = findUsagesManager.getFindUsagesHandler((PsiElement)method, false);
        if (handler == null) {
            return null;
        }
        JavaMethodFindUsagesOptions options = new JavaMethodFindUsagesOptions(project);
        options.isImplementingMethods = true;
        options.isOverridingMethods = true;
        options.isUsages = true;
        options.isSearchForTextOccurrences = false;
        int[] usagesFound = new int[1];
        Runnable runnable = () -> {
            Processor processor = t -> {
                usagesFound[0] = usagesFound[0] + 1;
                return usagesFound[0] < minUsagesNumber;
            };
            handler.processElementUsages((PsiElement)method, processor, (FindUsagesOptions)options);
        };
        String progressTitle = QuickFixBundle.message("searching.for.usages.progress.title", new Object[0]);
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, progressTitle, true, project)) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || usagesFound[0] < minUsagesNumber) {
            ChangeSignatureProcessor processor = new ChangeSignatureProcessor(project, method, false, null, method.getName(), method.getReturnType(), newParametersInfo){

                @NotNull
                protected UsageInfo[] findUsages() {
                    return changeAllUsages ? super.findUsages() : UsageInfo.EMPTY_ARRAY;
                }

                protected void performRefactoring(@NotNull UsageInfo[] usages) {
                    CommandProcessor.getInstance().setCurrentCommandName(this.getCommandName());
                    super.performRefactoring(usages);
                    if (callback != null) {
                        callback.consume(Arrays.asList(newParametersInfo));
                    }
                }
            };
            processor.run();
            ApplicationManager.getApplication().runWriteAction(() -> UndoUtil.markPsiFileForUndo((PsiFile)file));
            return Arrays.asList(newParametersInfo);
        }
        ArrayList<ParameterInfoImpl> parameterInfos = newParametersInfo != null ? new ArrayList<ParameterInfoImpl>(Arrays.asList(newParametersInfo)) : new ArrayList();
        PsiReferenceExpression refExpr = JavaTargetElementEvaluator.findReferenceExpression(editor);
        JavaChangeSignatureDialog dialog = JavaChangeSignatureDialog.createAndPreselectNew(project, method, parameterInfos, allowDelegation, refExpr, callback);
        dialog.setParameterInfos(parameterInfos);
        dialog.show();
        return dialog.isOK() ? dialog.getParameters() : null;
    }

    public static String getNewParameterNameByOldIndex(int oldIndex, ParameterInfoImpl[] parametersInfo) {
        if (parametersInfo == null) {
            return null;
        }
        for (ParameterInfoImpl info : parametersInfo) {
            if (info.oldParameterIndex != oldIndex) continue;
            return info.getName();
        }
        return null;
    }

    @Nullable
    protected ParameterInfoImpl[] getNewParametersInfo(PsiExpression[] expressions2, PsiMethod targetMethod, PsiSubstitutor substitutor) {
        return this.getNewParametersInfo(expressions2, targetMethod, substitutor, new StringBuilder(), new HashSet(), new HashSet(), new HashSet());
    }

    @Nullable
    private ParameterInfoImpl[] getNewParametersInfo(PsiExpression[] expressions2, PsiMethod targetMethod, PsiSubstitutor substitutor, StringBuilder buf, HashSet<? super ParameterInfoImpl> newParams, HashSet<? super ParameterInfoImpl> removedParams, HashSet<? super ParameterInfoImpl> changedParams) {
        PsiParameter[] parameters2 = targetMethod.getParameterList().getParameters();
        ArrayList<ParameterInfoImpl> result = new ArrayList<ParameterInfoImpl>();
        if (expressions2.length < parameters2.length) {
            int ei = 0;
            int pi = 0;
            while (ei < expressions2.length && pi < parameters2.length) {
                PsiExpression expression2 = expressions2[ei];
                PsiParameter parameter2 = parameters2[pi];
                PsiType paramType = substitutor.substitute(parameter2.getType());
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                PsiType parameterType = PsiUtil.convertAnonymousToBaseType((PsiType)paramType);
                String presentableText = ChangeMethodSignatureFromUsageFix.escapePresentableType(parameterType);
                ParameterInfoImpl parameterInfo = new ParameterInfoImpl(pi, parameter2.getName(), parameter2.getType());
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression2)) {
                    buf.append(presentableText);
                    result.add(parameterInfo);
                    ++pi;
                    ++ei;
                    continue;
                }
                buf.append("<s>").append(presentableText).append("</s>");
                removedParams.add(parameterInfo);
                ++pi;
            }
            if (result.size() != expressions2.length) {
                return null;
            }
            for (int i = pi; i < parameters2.length; ++i) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append("<s>").append(ChangeMethodSignatureFromUsageFix.escapePresentableType(parameters2[i].getType())).append("</s>");
                ParameterInfoImpl parameterInfo = new ParameterInfoImpl(pi, parameters2[i].getName(), parameters2[i].getType());
                removedParams.add(parameterInfo);
            }
        } else if (expressions2.length > parameters2.length) {
            if (!this.findNewParamsPlace(expressions2, targetMethod, substitutor, buf, newParams, parameters2, result)) {
                return null;
            }
        } else {
            for (int i = 0; i < parameters2.length; ++i) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                PsiParameter parameter3 = parameters2[i];
                PsiExpression expression3 = expressions2[i];
                PsiType bareParamType = parameter3.getType();
                if (!bareParamType.isValid()) {
                    try {
                        PsiUtil.ensureValidType((PsiType)bareParamType);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw PluginException.createByClass((String)(parameter3.getClass() + "; valid=" + parameter3.isValid() + "; method.valid=" + targetMethod.isValid()), (Throwable)e, parameter3.getClass());
                    }
                }
                PsiType paramType = substitutor.substitute(bareParamType);
                PsiUtil.ensureValidType((PsiType)paramType);
                String presentableText = ChangeMethodSignatureFromUsageFix.escapePresentableType(paramType);
                if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression3)) {
                    result.add(new ParameterInfoImpl(i, parameter3.getName(), paramType));
                    buf.append(presentableText);
                    continue;
                }
                if (PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expression3)) {
                    return null;
                }
                PsiType exprType = RefactoringUtil.getTypeByExpression(expression3);
                if (exprType == null || PsiType.VOID.equals((Object)exprType)) {
                    return null;
                }
                if (exprType instanceof PsiDisjunctionType) {
                    exprType = ((PsiDisjunctionType)exprType).getLeastUpperBound();
                }
                if (!PsiTypesUtil.allTypeParametersResolved((PsiElement)this.myTargetMethod, (PsiType)exprType)) {
                    return null;
                }
                ParameterInfoImpl changedParameterInfo = new ParameterInfoImpl(i, parameter3.getName(), exprType);
                result.add(changedParameterInfo);
                changedParams.add(changedParameterInfo);
                buf.append("<s>").append(presentableText).append("</s> <b>").append(ChangeMethodSignatureFromUsageFix.escapePresentableType(exprType)).append("</b>");
            }
            boolean isSilly = true;
            for (int i = 0; i < result.size(); ++i) {
                ParameterInfoImpl parameterInfo;
                String typeText;
                PsiParameter parameter4 = parameters2[i];
                PsiType paramType = substitutor.substitute(parameter4.getType());
                if (paramType.equalsToText(typeText = (parameterInfo = (ParameterInfoImpl)result.get(i)).getTypeText()) || paramType.getPresentableText().equals(typeText)) continue;
                isSilly = false;
                break;
            }
            if (isSilly) {
                return null;
            }
        }
        return result.toArray(new ParameterInfoImpl[0]);
    }

    @NotNull
    protected static String escapePresentableType(@NotNull PsiType exprType) {
        return StringUtil.escapeXmlEntities((String)exprType.getPresentableText());
    }

    protected boolean findNewParamsPlace(PsiExpression[] expressions2, PsiMethod targetMethod, PsiSubstitutor substitutor, StringBuilder buf, HashSet<? super ParameterInfoImpl> newParams, PsiParameter[] parameters2, List<? super ParameterInfoImpl> result) {
        PsiParameter varargParam;
        HashSet<String> existingNames = new HashSet<String>();
        for (PsiParameter parameter2 : parameters2) {
            existingNames.add(parameter2.getName());
        }
        int ei = 0;
        int pi = 0;
        PsiParameter psiParameter = varargParam = targetMethod.isVarArgs() ? parameters2[parameters2.length - 1] : null;
        while (ei < expressions2.length || pi < parameters2.length) {
            PsiType type2;
            boolean parameterAssignable;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            PsiExpression expression2 = ei < expressions2.length ? expressions2[ei] : null;
            PsiParameter parameter3 = pi < parameters2.length ? parameters2[pi] : null;
            PsiType paramType = parameter3 == null ? null : substitutor.substitute(parameter3.getType());
            boolean bl = parameterAssignable = paramType != null && (expression2 == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression2));
            if (parameterAssignable) {
                type2 = parameter3.getType();
                result.add(new ParameterInfoImpl(pi, parameter3.getName(), type2));
                buf.append(ChangeMethodSignatureFromUsageFix.escapePresentableType(type2));
                ++pi;
                ++ei;
                continue;
            }
            if (ChangeMethodSignatureFromUsageFix.isArgumentInVarargPosition(expressions2, ei, varargParam, substitutor)) {
                if (pi == parameters2.length - 1) {
                    assert (varargParam != null);
                    type2 = varargParam.getType();
                    result.add(new ParameterInfoImpl(pi, varargParam.getName(), type2));
                    buf.append(ChangeMethodSignatureFromUsageFix.escapePresentableType(type2));
                }
                ++pi;
                ++ei;
                continue;
            }
            if (expression2 == null) continue;
            if (varargParam != null && pi >= parameters2.length) {
                return false;
            }
            if (PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expression2)) {
                return false;
            }
            PsiType exprType = RefactoringUtil.getTypeByExpression(expression2);
            if (exprType == null || PsiType.VOID.equals((Object)exprType)) {
                return false;
            }
            if (exprType instanceof PsiDisjunctionType) {
                exprType = ((PsiDisjunctionType)exprType).getLeastUpperBound();
            }
            if (!PsiTypesUtil.allTypeParametersResolved((PsiElement)this.myTargetMethod, (PsiType)exprType)) {
                return false;
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression2.getProject());
            String name = ChangeMethodSignatureFromUsageFix.suggestUniqueParameterName(codeStyleManager, expression2, exprType, existingNames);
            ParameterInfoImpl newParameterInfo = new ParameterInfoImpl(-1, name, exprType, expression2.getText().replace('\n', ' '));
            result.add(newParameterInfo);
            newParams.add(newParameterInfo);
            buf.append("<b>").append(ChangeMethodSignatureFromUsageFix.escapePresentableType(exprType)).append("</b>");
            ++ei;
        }
        return result.size() == expressions2.length || varargParam != null;
    }

    static boolean isArgumentInVarargPosition(PsiExpression[] expressions2, int ei, PsiParameter varargParam, PsiSubstitutor substitutor) {
        if (varargParam == null) {
            return false;
        }
        PsiExpression expression2 = expressions2[ei];
        if (expression2 == null || TypeConversionUtil.areTypesAssignmentCompatible((PsiType)substitutor.substitute(((PsiEllipsisType)varargParam.getType()).getComponentType()), (PsiExpression)expression2)) {
            int lastExprIdx = expressions2.length - 1;
            if (ei == lastExprIdx) {
                return true;
            }
            return expressions2[lastExprIdx].getType() != PsiType.NULL;
        }
        return false;
    }

    static String suggestUniqueParameterName(JavaCodeStyleManager codeStyleManager, PsiExpression expression2, PsiType exprType, Set<? super String> existingNames) {
        PsiElement resolve;
        SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, expression2, exprType);
        String[] names = nameInfo.names;
        if (expression2 instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)expression2).resolve()) instanceof PsiVariable) {
            VariableKind variableKind = codeStyleManager.getVariableKind((PsiVariable)resolve);
            String propertyName = codeStyleManager.variableNameToPropertyName(((PsiVariable)resolve).getName(), variableKind);
            String parameterName = codeStyleManager.propertyNameToVariableName(propertyName, VariableKind.PARAMETER);
            names = ArrayUtil.mergeArrays((String[])new String[]{parameterName}, (String[])names);
        }
        if (names.length == 0) {
            names = new String[]{"param"};
        }
        int suffix = 0;
        while (true) {
            for (String name : names) {
                String suggested = name + (suffix == 0 ? "" : String.valueOf(suffix));
                if (!existingNames.add(suggested)) continue;
                return suggested;
            }
            ++suffix;
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

