/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ExtendsListFix;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeParameterClassFix
extends ExtendsListFix {
    public ChangeParameterClassFix(@NotNull PsiClass aClassToExtend, @NotNull PsiClassType parameterClass) {
        super(aClassToExtend, parameterClass, true);
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("change.parameter.class.family", new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass classToExtendFrom = this.myClassToExtendFromPointer != null ? (PsiClass)this.myClassToExtendFromPointer.getElement() : null;
        return super.isAvailable(project, file, startElement, endElement) && classToExtendFrom != null && classToExtendFrom.isValid() && classToExtendFrom.getQualifiedName() != null;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myClass = (PsiClass)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.invokeImpl(myClass));
        Editor editor1 = CodeInsightUtil.positionCursorAtLBrace(project, myClass.getContainingFile(), myClass);
        if (editor1 == null) {
            return;
        }
        Collection<CandidateInfo> toImplement = OverrideImplementExploreUtil.getMethodsToOverrideImplement(myClass, true);
        if (!toImplement.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    List members = ContainerUtil.map2List((Collection)toImplement, s -> new PsiMethodMember((CandidateInfo)s));
                    OverrideImplementUtil.overrideOrImplementMethodsInRightPlace(editor1, myClass, members, false);
                });
            } else {
                editor1.getCaretModel().moveToOffset(myClass.getTextRange().getStartOffset());
                OverrideImplementUtil.chooseAndImplementMethods(project, editor1, myClass);
            }
        }
        UndoUtil.markPsiFileForUndo((PsiFile)file);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

