/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTypeArgumentsFix
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(ChangeTypeArgumentsFix.class);
    private final PsiMethod myTargetMethod;
    private final PsiClass myPsiClass;
    private final PsiExpression[] myExpressions;
    private final PsiNewExpression myNewExpression;

    ChangeTypeArgumentsFix(@NotNull PsiMethod targetMethod, PsiClass psiClass, @NotNull PsiExpression[] expressions2, @NotNull PsiElement context) {
        this.myTargetMethod = targetMethod;
        this.myPsiClass = psiClass;
        this.myExpressions = expressions2;
        this.myNewExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiNewExpression.class);
    }

    @NotNull
    public String getText() {
        PsiSubstitutor substitutor = this.inferTypeArguments();
        return "Change type arguments to <" + StringUtil.join((Object[])this.myPsiClass.getTypeParameters(), typeParameter -> {
            PsiType substituted = substitutor.substitute(typeParameter);
            return substituted != null ? substituted.getPresentableText() : "java.lang.Object";
        }, (String)", ") + ">";
    }

    @NotNull
    public String getFamilyName() {
        return "Change type arguments";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement reference;
        if (!this.myPsiClass.isValid() || !this.myTargetMethod.isValid()) {
            return false;
        }
        PsiTypeParameter[] typeParameters = this.myPsiClass.getTypeParameters();
        if (typeParameters.length > 0 && this.myNewExpression != null && this.myNewExpression.isValid() && this.myNewExpression.getArgumentList() != null && (reference = this.myNewExpression.getClassOrAnonymousClassReference()) != null && (parameterList = reference.getParameterList()) != null) {
            PsiSubstitutor substitutor = this.inferTypeArguments();
            PsiParameter[] parameters2 = this.myTargetMethod.getParameterList().getParameters();
            if (parameters2.length != this.myExpressions.length) {
                return false;
            }
            int length = parameters2.length;
            for (int i = 0; i < length; ++i) {
                PsiParameter parameter2 = parameters2[i];
                PsiType expectedType = substitutor.substitute(parameter2.getType());
                if (!this.myExpressions[i].isValid()) {
                    return false;
                }
                PsiType actualType = this.myExpressions[i].getType();
                if (expectedType != null && actualType != null && TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)actualType)) continue;
                return false;
            }
            for (PsiTypeParameter parameter3 : typeParameters) {
                if (substitutor.substitute(parameter3) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        PsiTypeParameter[] typeParameters = this.myPsiClass.getTypeParameters();
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments();
        PsiJavaCodeReferenceElement reference = this.myNewExpression.getClassOrAnonymousClassReference();
        LOG.assertTrue(reference != null, (Object)this.myNewExpression);
        PsiReferenceParameterList parameterList = reference.getParameterList();
        LOG.assertTrue(parameterList != null, (Object)this.myNewExpression);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiTypeElement[] elements = parameterList.getTypeParameterElements();
        for (int i = elements.length - 1; i >= 0; --i) {
            PsiType typeArg = (PsiType)ObjectUtils.assertNotNull((Object)psiSubstitutor.substitute(typeParameters[i]));
            PsiElement replaced = elements[i].replace((PsiElement)factory.createTypeElement(typeArg));
            JavaCodeStyleManager.getInstance((Project)file.getProject()).shortenClassReferences(replaced);
        }
    }

    private PsiSubstitutor inferTypeArguments() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myNewExpression.getProject());
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiParameter[] parameters2 = this.myTargetMethod.getParameterList().getParameters();
        PsiExpressionList argumentList = this.myNewExpression.getArgumentList();
        LOG.assertTrue(argumentList != null);
        PsiExpression[] expressions2 = argumentList.getExpressions();
        return resolveHelper.inferTypeArguments(this.myPsiClass.getTypeParameters(), parameters2, expressions2, PsiSubstitutor.EMPTY, this.myNewExpression.getParent(), (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    public static void registerIntentions(@NotNull JavaResolveResult[] candidates, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo, PsiClass psiClass) {
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions2 = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            ChangeTypeArgumentsFix.registerIntention(expressions2, highlightInfo, psiClass, candidate, (PsiElement)list);
        }
    }

    private static void registerIntention(@NotNull PsiExpression[] expressions2, @Nullable HighlightInfo highlightInfo, PsiClass psiClass, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        if (method != null && BaseIntentionAction.canModify((PsiElement)method)) {
            ChangeTypeArgumentsFix fix2 = new ChangeTypeArgumentsFix(method, psiClass, expressions2, context);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, null, (IntentionAction)fix2);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

