/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.editorActions.StringLiteralCopyPasteProcessor;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ConvertRawToStringLiteralAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return QuickFixBundle.message("convert.to.string.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return "Convert raw to String literal";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.RAW_STRING_LITERAL);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement parent;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element != null && PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.RAW_STRING_LITERAL) && (parent = element.getParent()) instanceof PsiLiteralExpressionImpl) {
            String text2 = ((PsiLiteralExpressionImpl)parent).getRawString();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiElement literalToken = elementFactory.createExpressionFromText("\"\"", (PsiElement)file).getFirstChild();
            String preprocessedValue = new StringLiteralCopyPasteProcessor().escapeAndSplit(text2, literalToken);
            PsiExpression replacement = elementFactory.createExpressionFromText('\"' + preprocessedValue + '\"', null);
            PsiExpression replacedExpression = ExpressionUtils.replacePolyadicWithParent((PsiExpression)parent, replacement);
            if (replacedExpression == null) {
                replacedExpression = parent.replace((PsiElement)replacement);
            }
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)replacedExpression);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

