/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiRawStringLiteralUtil;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.concatenation.CopyConcatenatedStringToClipboardIntention;
import org.jetbrains.annotations.NotNull;

public class ConvertStringLiteralToRawAction
implements IntentionAction,
LowPriorityAction {
    @NotNull
    public String getText() {
        return QuickFixBundle.message("convert.to.raw.string.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return "Convert to raw string literal";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement parent;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.STRING_LITERAL) && HighlightUtil.Feature.RAW_LITERALS.isAvailable((PsiElement)file) && (parent = element.getParent()) instanceof PsiLiteralExpressionImpl) {
            String text2 = ((PsiLiteralExpressionImpl)parent).getInnerText();
            return text2 != null && PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2) < text2.length();
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement parent;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element != null && PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.STRING_LITERAL) && (parent = element.getParent()) instanceof PsiLiteralExpressionImpl) {
            String text2;
            PsiElement elementToReplace = parent;
            PsiElement gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent());
            if (gParent instanceof PsiPolyadicExpression) {
                text2 = CopyConcatenatedStringToClipboardIntention.buildConcatenationText((PsiPolyadicExpression)gParent);
                elementToReplace = gParent;
            } else {
                String innerText = ((PsiLiteralExpressionImpl)parent).getInnerText();
                if (innerText == null) {
                    return;
                }
                text2 = StringUtil.unescapeStringCharacters((String)innerText);
            }
            String prefix = "";
            int startingSeq = PsiRawStringLiteralUtil.getLeadingTicksSequence((CharSequence)text2);
            if (startingSeq > 0) {
                prefix = "\"" + StringUtil.repeat((String)"`", (int)startingSeq) + "\" + ";
            }
            String suffix = "";
            int trailingSequence = PsiRawStringLiteralUtil.getTrailingTicksSequence((CharSequence)text2);
            if (trailingSequence > 0) {
                suffix = "+ \"" + StringUtil.repeat((String)"`", (int)trailingSequence) + "\"";
            }
            String textTicsTrimmed = text2.substring(Math.max(startingSeq, 0), text2.length() - Math.max(trailingSequence, 0));
            String additionalQuotes = PsiRawStringLiteralUtil.getAdditionalTicks((String)textTicsTrimmed, (String)"`");
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            CodeStyleManager.getInstance((Project)project).reformat(elementToReplace.replace((PsiElement)elementFactory.createExpressionFromText(prefix + '`' + additionalQuotes + StringUtil.convertLineSeparators((String)textTicsTrimmed) + additionalQuotes + '`' + suffix, null)));
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

