/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ConvertToStringLiteralAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return QuickFixBundle.message("convert.to.string.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("convert.to.string.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.CHARACTER_LITERAL);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        String text2;
        int length;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element != null && PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.CHARACTER_LITERAL) && (length = (text2 = StringUtil.unescapeStringCharacters((String)element.getText())).length()) > 1 && text2.charAt(0) == '\'' && text2.charAt(length - 1) == '\'') {
            String value2 = StringUtil.escapeStringCharacters((String)text2.substring(1, length - 1));
            PsiExpression expression2 = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText('\"' + value2 + '\"', null);
            PsiElement literal = expression2.getFirstChild();
            if (literal != null && PsiUtil.isJavaToken((PsiElement)literal, (IElementType)JavaTokenType.STRING_LITERAL)) {
                element.replace(literal);
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

