/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateClassFromNewFix
extends CreateFromUsageBaseFix {
    private final SmartPsiElementPointer myNewExpression;

    public CreateClassFromNewFix(PsiNewExpression newExpression) {
        this.myNewExpression = SmartPointerManager.getInstance((Project)newExpression.getProject()).createSmartPsiElementPointer((PsiElement)newExpression);
    }

    protected PsiNewExpression getNewExpression() {
        return (PsiNewExpression)this.myNewExpression.getElement();
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        assert (ApplicationManager.getApplication().isWriteAccessAllowed());
        Project project = targetClass.getProject();
        TransactionGuard.getInstance().submitTransactionLater((Disposable)project, () -> {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiNewExpression newExpression = this.getNewExpression();
            if (newExpression == null) {
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = CreateClassFromNewFix.getReferenceElement(newExpression);
            PsiClass[] psiClass = new PsiClass[1];
            CommandProcessor.getInstance().executeCommand(newExpression.getProject(), () -> {
                psiClass[0] = CreateFromUsageUtils.createClass(referenceElement, CreateClassKind.CLASS, null);
            }, this.getText(), (Object)this.getText());
            WriteCommandAction.writeCommandAction((Project)project).withName(this.getText()).withGroupId(this.getText()).run(() -> this.setupClassFromNewExpression(psiClass[0], newExpression));
        });
    }

    protected void setupClassFromNewExpression(PsiClass psiClass, PsiNewExpression newExpression) {
        assert (ApplicationManager.getApplication().isWriteAccessAllowed());
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)newExpression.getProject());
        PsiClass aClass = psiClass;
        if (aClass == null) {
            return;
        }
        PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
        if (classReference2 != null) {
            classReference2.bindToElement((PsiElement)aClass);
        }
        CreateClassFromNewFix.setupInheritance(newExpression, aClass);
        PsiExpressionList argList = newExpression.getArgumentList();
        Project project = aClass.getProject();
        if (argList != null && !argList.isEmpty()) {
            PsiMethod constructor = elementFactory.createConstructor();
            constructor = (PsiMethod)aClass.add((PsiElement)constructor);
            TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)aClass);
            CreateFromUsageUtils.setupMethodParameters(constructor, (TemplateBuilder)templateBuilder, argList, CreateClassFromNewFix.getTargetSubstitutor((PsiElement)newExpression));
            CreateClassFromNewFix.setupSuperCall(aClass, constructor, templateBuilder);
            CreateClassFromNewFix.getReferenceElement(newExpression).bindToElement((PsiElement)aClass);
            aClass = (PsiClass)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)aClass);
            Template template = templateBuilder.buildTemplate();
            template.setToReformat(true);
            Editor editor = CreateClassFromNewFix.positionCursor(project, aClass.getContainingFile(), (PsiElement)aClass);
            if (editor == null) {
                return;
            }
            RangeMarker textRange = editor.getDocument().createRangeMarker(aClass.getTextRange());
            Runnable runnable = () -> {
                WriteCommandAction.writeCommandAction((Project)project).withName(this.getText()).withGroupId(this.getText()).run(() -> {
                    try {
                        editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
                    }
                    finally {
                        textRange.dispose();
                    }
                });
                CreateClassFromNewFix.startTemplate(editor, template, project, null, this.getText());
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                runnable.run();
            } else {
                ApplicationManager.getApplication().invokeLater(runnable);
            }
        } else {
            CreateClassFromNewFix.positionCursor(project, aClass.getContainingFile(), (PsiElement)ObjectUtils.notNull((Object)aClass.getNameIdentifier(), (Object)aClass));
        }
    }

    @Nullable
    public static PsiMethod setupSuperCall(PsiClass targetClass, PsiMethod constructor, TemplateBuilderImpl templateBuilder) throws IncorrectOperationException {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)targetClass.getProject());
        PsiMethod supConstructor = null;
        PsiClass superClass = targetClass.getSuperClass();
        if (superClass != null && !"java.lang.Object".equals(superClass.getQualifiedName()) && !"java.lang.Enum".equals(superClass.getQualifiedName())) {
            PsiMethod[] constructors = superClass.getConstructors();
            boolean hasDefaultConstructor = false;
            for (PsiMethod superConstructor : constructors) {
                if (superConstructor.getParameterList().isEmpty()) {
                    hasDefaultConstructor = true;
                    supConstructor = null;
                    break;
                }
                supConstructor = superConstructor;
            }
            if (!hasDefaultConstructor) {
                PsiExpressionStatement statement = (PsiExpressionStatement)elementFactory.createStatementFromText("super();", (PsiElement)constructor);
                statement = (PsiExpressionStatement)constructor.getBody().add((PsiElement)statement);
                PsiMethodCallExpression call = (PsiMethodCallExpression)statement.getExpression();
                PsiExpressionList argumentList = call.getArgumentList();
                templateBuilder.setEndVariableAfter(argumentList.getFirstChild());
                return supConstructor;
            }
        }
        templateBuilder.setEndVariableAfter((PsiElement)constructor.getBody().getLBrace());
        return supConstructor;
    }

    private static void setupInheritance(PsiNewExpression element, PsiClass targetClass) throws IncorrectOperationException {
        ExpectedTypeInfo[] expectedTypes;
        if (element.getParent() instanceof PsiReferenceExpression) {
            return;
        }
        for (ExpectedTypeInfo expectedType : expectedTypes = ExpectedTypesProvider.getExpectedTypes((PsiExpression)element, false)) {
            PsiClassType classType;
            PsiClass aClass;
            PsiType type2 = expectedType.getType();
            if (!(type2 instanceof PsiClassType) || (aClass = (classType = (PsiClassType)type2).resolve()) == null || aClass.equals(targetClass) || aClass.hasModifierProperty("final")) continue;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
            if (aClass.isInterface()) {
                PsiReferenceList implementsList = targetClass.getImplementsList();
                assert (implementsList != null) : targetClass;
                implementsList.add((PsiElement)factory.createReferenceElementByType(classType));
                continue;
            }
            PsiReferenceList extendsList = targetClass.getExtendsList();
            assert (extendsList != null) : targetClass;
            if (extendsList.getReferencedTypes().length != 0 || "java.lang.Object".equals(classType.getCanonicalText())) continue;
            extendsList.add((PsiElement)factory.createReferenceElementByType(classType));
        }
    }

    private static PsiFile getTargetFile(PsiElement element) {
        PsiJavaCodeReferenceElement qualifier;
        PsiElement psiElement;
        PsiJavaCodeReferenceElement referenceElement = CreateClassFromNewFix.getReferenceElement((PsiNewExpression)element);
        PsiElement q = referenceElement.getQualifier();
        if (q instanceof PsiJavaCodeReferenceElement && (psiElement = (qualifier = (PsiJavaCodeReferenceElement)q).resolve()) instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psiElement;
            return psiClass.getContainingFile();
        }
        return null;
    }

    @Override
    protected PsiElement getElement() {
        PsiNewExpression expression2 = this.getNewExpression();
        if (expression2 == null || !expression2.getManager().isInProject((PsiElement)expression2)) {
            return null;
        }
        PsiJavaCodeReferenceElement referenceElement = CreateClassFromNewFix.getReferenceElement(expression2);
        if (referenceElement == null) {
            return null;
        }
        if (referenceElement.getReferenceNameElement() instanceof PsiIdentifier) {
            return expression2;
        }
        return null;
    }

    @Override
    protected boolean isAllowOuterTargetClass() {
        return false;
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)element, PsiJavaCodeReferenceElement.class);
        return ref != null && ref.resolve() != null;
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiNewExpression expression2 = this.getNewExpression();
        if (this.rejectQualifier(expression2.getQualifier())) {
            return false;
        }
        PsiFile targetFile = CreateClassFromNewFix.getTargetFile((PsiElement)expression2);
        if (targetFile != null && !targetFile.getManager().isInProject((PsiElement)targetFile)) {
            return false;
        }
        PsiElement nameElement = CreateClassFromNewFix.getNameElement(expression2);
        if (CreateFromUsageUtils.shouldShowTag(offset, nameElement, (PsiElement)expression2)) {
            String varName = nameElement.getText();
            this.setText(this.getText(varName));
            return true;
        }
        return false;
    }

    protected boolean rejectQualifier(PsiExpression qualifier) {
        return qualifier != null;
    }

    protected String getText(String varName) {
        return QuickFixBundle.message("create.class.from.new.text", varName);
    }

    protected static PsiJavaCodeReferenceElement getReferenceElement(PsiNewExpression expression2) {
        return expression2.getClassOrAnonymousClassReference();
    }

    private static PsiElement getNameElement(PsiNewExpression targetElement) {
        PsiJavaCodeReferenceElement referenceElement = CreateClassFromNewFix.getReferenceElement(targetElement);
        return referenceElement != null ? referenceElement.getReferenceNameElement() : null;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.class.from.new.family", new Object[0]);
    }

    @Override
    protected boolean canBeTargetClass(PsiClass psiClass) {
        return false;
    }
}

