/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class CreateConstructorFromThisOrSuperFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.CreateConstructorFromThisOrSuperFix");
    protected PsiMethodCallExpression myMethodCall;

    public CreateConstructorFromThisOrSuperFix(PsiMethodCallExpression methodCall) {
        this.myMethodCall = methodCall;
    }

    @NonNls
    protected abstract String getSyntheticMethodName();

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiReferenceExpression ref = this.myMethodCall.getMethodExpression();
        if (!ref.getText().equals(this.getSyntheticMethodName())) {
            return false;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myMethodCall, PsiMethod.class);
        if (method == null || !method.isConstructor()) {
            return false;
        }
        if (CreateMethodFromUsageFix.hasErrorsInArgumentList(this.myMethodCall)) {
            return false;
        }
        List<PsiClass> targetClasses = this.getTargetClasses((PsiElement)this.myMethodCall);
        if (targetClasses.isEmpty()) {
            return false;
        }
        if (CreateFromUsageUtils.shouldShowTag(offset, ref.getReferenceNameElement(), (PsiElement)this.myMethodCall)) {
            this.setText(QuickFixBundle.message("create.constructor.text", targetClasses.get(0).getName()));
            return true;
        }
        return false;
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        final PsiFile callSite = this.myMethodCall.getContainingFile();
        final Project project = this.myMethodCall.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
        try {
            PsiMethod constructor = elementFactory.createConstructor();
            constructor = (PsiMethod)targetClass.add((PsiElement)constructor);
            TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)constructor);
            CreateFromUsageUtils.setupMethodParameters(constructor, (TemplateBuilder)templateBuilder, this.myMethodCall.getArgumentList(), CreateConstructorFromThisOrSuperFix.getTargetSubstitutor((PsiElement)this.myMethodCall));
            PsiFile psiFile = this.myMethodCall.getContainingFile();
            templateBuilder.setEndVariableAfter((PsiElement)constructor.getBody().getLBrace());
            RangeMarker rangeMarker = psiFile.getViewProvider().getDocument().createRangeMarker(this.myMethodCall.getTextRange());
            constructor = (PsiMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)constructor);
            targetClass = constructor.getContainingClass();
            this.myMethodCall = (PsiMethodCallExpression)CodeInsightUtil.findElementInRange(psiFile, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), this.myMethodCall.getClass());
            rangeMarker.dispose();
            Template template = templateBuilder.buildTemplate();
            final Editor editor = CreateConstructorFromThisOrSuperFix.positionCursor(project, targetClass.getContainingFile(), (PsiElement)targetClass);
            if (editor == null) {
                return;
            }
            TextRange textRange = constructor.getTextRange();
            final PsiFile file = targetClass.getContainingFile();
            editor.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset());
            editor.getCaretModel().moveToOffset(textRange.getStartOffset());
            CreateConstructorFromThisOrSuperFix.startTemplate(editor, template, project, (TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        try {
                            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                            int offset = editor.getCaretModel().getOffset();
                            PsiMethod constructor1 = (PsiMethod)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiMethod.class, (boolean)false);
                            CreateFromUsageUtils.setupMethodBody(constructor1);
                            CreateFromUsageUtils.setupEditor(constructor1, editor);
                            UndoUtil.markPsiFileForUndo((PsiFile)callSite);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    });
                }
            });
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
        PsiMethod method = (PsiMethod)methodCall.getMethodExpression().resolve();
        PsiExpressionList argumentList = methodCall.getArgumentList();
        List<PsiClass> classes2 = this.getTargetClasses(element);
        return !classes2.isEmpty() && !CreateFromUsageUtils.shouldCreateConstructor(classes2.get(0), argumentList, method);
    }

    @Override
    protected PsiElement getElement() {
        if (!this.myMethodCall.isValid() || !CreateConstructorFromThisOrSuperFix.canModify((PsiElement)this.myMethodCall)) {
            return null;
        }
        return this.myMethodCall;
    }
}

