/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateEnumConstantFromUsageFix
extends CreateVarFromUsageFix
implements HighPriorityAction {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.codeInsight.daemon.impl.quickfix.CreateEnumConstantFromUsageFix");

    public CreateEnumConstantFromUsageFix(PsiReferenceExpression referenceElement) {
        super(referenceElement);
    }

    @Override
    protected String getText(String varName) {
        return QuickFixBundle.message("create.enum.constant.from.usage.text", this.myReferenceExpression.getReferenceName());
    }

    @Override
    protected void invokeImpl(PsiClass targetClass) {
        PsiMethod constructor;
        Object[] parameters2;
        LOG.assertTrue(targetClass.isEnum());
        String name = this.myReferenceExpression.getReferenceName();
        LOG.assertTrue(name != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myReferenceExpression.getProject());
        PsiEnumConstant enumConstant = elementFactory.createEnumConstantFromText(name, null);
        enumConstant = (PsiEnumConstant)targetClass.add((PsiElement)enumConstant);
        PsiMethod[] constructors = targetClass.getConstructors();
        if (constructors.length > 0 && (parameters2 = (constructor = constructors[0]).getParameterList().getParameters()).length > 0) {
            String params = StringUtil.join((Object[])parameters2, psiParameter -> psiParameter.getName(), (String)",");
            enumConstant = (PsiEnumConstant)enumConstant.replace((PsiElement)elementFactory.createEnumConstantFromText(name + "(" + params + ")", null));
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)enumConstant);
            PsiExpressionList argumentList = enumConstant.getArgumentList();
            LOG.assertTrue(argumentList != null);
            for (PsiExpression expression2 : argumentList.getExpressions()) {
                builder.replaceElement((PsiElement)expression2, (Expression)new EmptyExpression());
            }
            enumConstant = (PsiEnumConstant)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)enumConstant);
            Template template = builder.buildTemplate();
            Project project = targetClass.getProject();
            Editor newEditor = CreateEnumConstantFromUsageFix.positionCursor(project, targetClass.getContainingFile(), (PsiElement)enumConstant);
            if (newEditor != null) {
                TextRange range = enumConstant.getTextRange();
                newEditor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
                CreateEnumConstantFromUsageFix.startTemplate(newEditor, template, project);
            }
        }
    }

    @Override
    @NotNull
    protected List<PsiClass> getTargetClasses(PsiElement element) {
        List<PsiClass> classes2 = super.getTargetClasses(element);
        PsiClass enumClass = null;
        for (PsiClass aClass : classes2) {
            if (!aClass.isEnum()) continue;
            if (enumClass == null) {
                enumClass = aClass;
                continue;
            }
            enumClass = null;
            break;
        }
        if (enumClass != null) {
            return Collections.singletonList(enumClass);
        }
        if (this.myReferenceExpression.isQualified()) {
            PsiClass aClass = CreateEnumConstantFromUsageFix.getTargetClassByExpectedTypes(this.myReferenceExpression.getQualifierExpression());
            if (aClass != null) {
                return Collections.singletonList(aClass);
            }
        } else {
            PsiImportList importList;
            PsiFile containingFile;
            PsiClass targetClass = CreateEnumConstantFromUsageFix.getTargetClassByExpectedTypes((PsiExpression)this.myReferenceExpression);
            if (targetClass != null && (containingFile = this.myReferenceExpression.getContainingFile()) instanceof PsiJavaFile && (importList = ((PsiJavaFile)containingFile).getImportList()) != null) {
                for (PsiImportStaticStatement statement : importList.getImportStaticStatements()) {
                    if (!statement.isOnDemand() || !targetClass.equals(statement.resolveTargetClass())) continue;
                    return Collections.singletonList(targetClass);
                }
            }
        }
        return Collections.emptyList();
    }

    private static PsiClass getTargetClassByExpectedTypes(PsiExpression expression2) {
        ExpectedTypeInfo[] typeInfos;
        for (ExpectedTypeInfo typeInfo : typeInfos = CreateFromUsageUtils.guessExpectedTypes(expression2, false)) {
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)typeInfo.getType());
            if (psiClass == null || !psiClass.isEnum()) continue;
            return psiClass;
        }
        return null;
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        if (!super.isAvailableImpl(offset)) {
            return false;
        }
        PsiElement element = this.getElement();
        List<PsiClass> classes2 = this.getTargetClasses(element);
        if (classes2.size() != 1 || !classes2.get(0).isEnum()) {
            return false;
        }
        ExpectedTypeInfo[] typeInfos = CreateFromUsageUtils.guessExpectedTypes((PsiExpression)this.myReferenceExpression, false);
        PsiClassType enumType = JavaPsiFacade.getElementFactory((Project)this.myReferenceExpression.getProject()).createType(classes2.get(0));
        for (ExpectedTypeInfo typeInfo : typeInfos) {
            if (!ExpectedTypeUtil.matches((PsiType)enumType, typeInfo)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.constant.from.usage.family", new Object[0]);
    }
}

