/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.CreatePropertyFromUsageFix;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PropertyUtilBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateGetterSetterPropertyFromUsageFix
extends CreatePropertyFromUsageFix {
    public CreateGetterSetterPropertyFromUsageFix(@NotNull PsiMethodCallExpression methodCall) {
        super(methodCall);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        boolean available = super.isAvailableImpl(offset);
        if (available) {
            this.setText("Create property");
        }
        return available;
    }

    @Override
    protected boolean checkTargetClasses(List<? extends PsiClass> classes2, String methodName) {
        String propertyName = PropertyUtilBase.getPropertyName((String)methodName);
        if (propertyName == null) {
            return false;
        }
        String getterName = PropertyUtilBase.suggestGetterName((String)propertyName, null);
        String setterName = PropertyUtilBase.suggestSetterName((String)propertyName);
        for (PsiClass psiClass : classes2) {
            if (psiClass.findMethodsByName(getterName, false).length <= 0 && psiClass.findMethodsByName(setterName, false).length <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void beforeTemplateFinished(PsiClass aClass, PsiField field) {
        PsiMethod setterPrototype;
        PsiMethod getterPrototype = GenerateMembersUtil.generateSimpleGetterPrototype(field);
        if (aClass.findMethodsBySignature(getterPrototype, false).length == 0) {
            aClass.add((PsiElement)getterPrototype);
        }
        if (aClass.findMethodsBySignature(setterPrototype = GenerateMembersUtil.generateSimpleSetterPrototype(field), false).length == 0) {
            aClass.add((PsiElement)setterPrototype);
        }
        super.beforeTemplateFinished(aClass, field);
    }
}

