/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class CreateInnerClassFromUsageFix
extends CreateClassFromUsageBaseFix {
    public CreateInnerClassFromUsageFix(PsiJavaCodeReferenceElement refElement, CreateClassKind kind2) {
        super(kind2, refElement);
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.inner.class.from.usage.text", this.myKind.getDescription(), varName);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiJavaCodeReferenceElement element = this.getRefElement();
        if (element == null) {
            return;
        }
        String superClassName = this.getSuperClassName(element);
        PsiClass[] targets = CreateInnerClassFromUsageFix.getPossibleTargets(element);
        LOG.assertTrue(targets.length > 0);
        if (targets.length == 1) {
            this.doInvoke(targets[0], superClassName);
        } else {
            this.chooseTargetClass(targets, editor, superClassName);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return super.isAvailable(project, editor, file) && CreateInnerClassFromUsageFix.getPossibleTargets(this.getRefElement()).length > 0;
    }

    @NotNull
    private static PsiClass[] getPossibleTargets(PsiJavaCodeReferenceElement element) {
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        PsiJavaCodeReferenceElement run = element;
        PsiMember contextMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)run, PsiMember.class);
        while (contextMember != null) {
            if (contextMember instanceof PsiClass && !(contextMember instanceof PsiTypeParameter) && !CreateInnerClassFromUsageFix.isUsedInExtends((PsiElement)run, (PsiClass)contextMember)) {
                result.add((PsiClass)contextMember);
            }
            run = contextMember;
            contextMember = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)run, PsiMember.class);
        }
        return result.isEmpty() ? PsiClass.EMPTY_ARRAY : result.toArray(PsiClass.EMPTY_ARRAY);
    }

    private static boolean isUsedInExtends(PsiElement element, PsiClass psiClass) {
        PsiReferenceList extendsList = psiClass.getExtendsList();
        PsiReferenceList implementsList = psiClass.getImplementsList();
        if (extendsList != null && PsiTreeUtil.isAncestor((PsiElement)extendsList, (PsiElement)element, (boolean)false)) {
            return true;
        }
        return implementsList != null && PsiTreeUtil.isAncestor((PsiElement)implementsList, (PsiElement)element, (boolean)false);
    }

    private void chooseTargetClass(PsiClass[] classes2, Editor editor, String superClassName) {
        PsiClassListCellRenderer renderer = new PsiClassListCellRenderer();
        IPopupChooserBuilder builder = JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList((Object[])classes2)).setSelectionMode(0).setRenderer((ListCellRenderer)((Object)renderer)).setTitle(QuickFixBundle.message("target.class.chooser.title", new Object[0])).setItemChosenCallback(aClass -> this.doInvoke((PsiClass)aClass, superClassName));
        renderer.installSpeedSearch(builder);
        builder.createPopup().showInBestPositionFor(editor);
    }

    private void doInvoke(PsiClass aClass, String superClassName) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement ref = this.getRefElement();
        assert (ref != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)aClass)) {
            return;
        }
        String refName = ref.getReferenceName();
        LOG.assertTrue(refName != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
        PsiClass created = this.myKind == CreateClassKind.INTERFACE ? elementFactory.createInterface(refName) : (this.myKind == CreateClassKind.CLASS ? elementFactory.createClass(refName) : elementFactory.createEnum(refName));
        PsiModifierList modifierList = created.getModifierList();
        LOG.assertTrue(modifierList != null);
        if (aClass.isInterface() || PsiUtil.isLocalOrAnonymousClass((PsiClass)aClass)) {
            modifierList.setModifierProperty("packageLocal", true);
        } else {
            modifierList.setModifierProperty("private", true);
        }
        if (RefactoringUtil.isInStaticContext((PsiElement)ref, aClass) && !aClass.isInterface()) {
            modifierList.setModifierProperty("static", true);
        }
        if (superClassName != null) {
            CreateFromUsageUtils.setupSuperClassReference(created, superClassName);
        }
        CreateFromUsageBaseFix.setupGenericParameters(created, ref);
        WriteCommandAction.runWriteCommandAction((Project)aClass.getProject(), (String)this.getText(), null, () -> ref.bindToElement(aClass.add((PsiElement)created)), (PsiFile[])new PsiFile[]{aClass.getContainingFile()});
    }
}

