/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateMethodQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    protected final String mySignature;
    protected final String myBody;

    private CreateMethodQuickFix(PsiClass targetClass, @NonNls String signature, @NonNls String body2) {
        super((PsiElement)targetClass);
        this.mySignature = signature;
        this.myBody = body2;
    }

    @NotNull
    public String getText() {
        PsiClass myTargetClass = (PsiClass)this.getStartElement();
        String signature = myTargetClass == null ? "" : PsiFormatUtil.formatMethod((PsiMethod)this.createMethod(myTargetClass), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)65795, (int)65538, (int)2);
        return QuickFixBundle.message("create.method.from.usage.text", signature);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClass myTargetClass = (PsiClass)startElement;
        PsiMethod method = this.createMethod(myTargetClass);
        List arguments = ContainerUtil.map2List((Object[])method.getParameterList().getParameters(), psiParameter -> Pair.create(null, (Object)psiParameter.getType()));
        method = (PsiMethod)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(myTargetClass.add((PsiElement)method));
        CreateMethodFromUsageFix.doCreate(myTargetClass, method, arguments, PsiSubstitutor.EMPTY, ExpectedTypeInfo.EMPTY_ARRAY, (PsiElement)method);
    }

    private PsiMethod createMethod(@NotNull PsiClass myTargetClass) {
        Project project = myTargetClass.getProject();
        JVMElementFactory elementFactory = JVMElementFactories.getFactory((Language)myTargetClass.getLanguage(), (Project)project);
        if (elementFactory == null) {
            elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        }
        String methodText = this.mySignature + (myTargetClass.isInterface() ? ";" : "{" + this.myBody + "}");
        return elementFactory.createMethodFromText(methodText, null);
    }

    @Nullable
    public static CreateMethodQuickFix createFix(@NotNull PsiClass targetClass, @NonNls String signature, @NonNls String body2) {
        CreateMethodQuickFix fix2 = new CreateMethodQuickFix(targetClass, signature, body2);
        try {
            fix2.createMethod(targetClass);
            return fix2;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }
}

