/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateServiceClassFixBase
implements IntentionAction {
    public static final Key<PsiDirectory> SERVICE_ROOT_DIR = Key.create((String)"SERVICE_ROOT_DIR");
    public static final Key<CreateClassKind> SERVICE_CLASS_KIND = Key.create((String)"SERVICE_CLASS_KIND");
    public static final Key<Boolean> SERVICE_IS_SUBCLASS = Key.create((String)"SERVICE_IS_SUBCLASS");

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected static PsiJavaCodeReferenceElement findTopmostReference(@NotNull PsiJavaCodeReferenceElement referenceElement) {
        PsiElement parent = referenceElement.getParent();
        while (parent instanceof PsiJavaCodeReferenceElement) {
            referenceElement = (PsiJavaCodeReferenceElement)parent;
            parent = parent.getParent();
        }
        return referenceElement;
    }

    protected static boolean isQualifierInProject(@NotNull String classFQN, @NotNull Project project) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        String qualifierText = StringUtil.getPackageName((String)classFQN);
        PsiClass outerClass = psiFacade.findClass(qualifierText, GlobalSearchScope.projectScope((Project)project));
        if (outerClass != null) {
            return psiManager.isInProject((PsiElement)outerClass);
        }
        while (!StringUtil.isEmpty((String)qualifierText)) {
            PsiPackage psiPackage = psiFacade.findPackage(qualifierText);
            if (psiPackage != null) {
                return psiManager.isInProject((PsiElement)psiPackage);
            }
            qualifierText = StringUtil.getPackageName((String)qualifierText);
        }
        return false;
    }

    @NotNull
    protected static PsiClass createClassInOuterImpl(@NotNull String name, @NotNull PsiClass outerClass, @Nullable String superClassName) {
        Project project = outerClass.getProject();
        PsiClass psiClass = JavaPsiFacade.getElementFactory((Project)project).createClass(name);
        psiClass = (PsiClass)outerClass.addBefore((PsiElement)psiClass, outerClass.getRBrace());
        PsiUtil.setModifierProperty((PsiModifierListOwner)psiClass, (String)"static", (boolean)true);
        PsiUtil.setModifierProperty((PsiModifierListOwner)psiClass, (String)"public", (boolean)true);
        if (superClassName != null) {
            CreateFromUsageUtils.setupSuperClassReference(psiClass, superClassName);
        }
        return psiClass;
    }

    @Nullable
    public static PsiDirectory getOrCreatePackageDirInRoot(@NotNull String packageName, @NotNull PsiDirectory rootDir) {
        String[] shortNames;
        if (packageName.isEmpty()) {
            return rootDir;
        }
        PsiDirectory directory = rootDir;
        for (String lastName : shortNames = packageName.split("\\.")) {
            PsiDirectory subdirectory = directory.findSubdirectory(lastName);
            if (subdirectory != null) {
                directory = subdirectory;
                continue;
            }
            try {
                directory = directory.createSubdirectory(lastName);
            }
            catch (IncorrectOperationException e) {
                CreateFromUsageUtils.scheduleFileOrPackageCreationFailedMessageBox(e, lastName, directory, true);
                return null;
            }
        }
        return directory;
    }

    @Nullable
    protected static PsiClass createClassInRoot(@NotNull String classFQN, @NotNull CreateClassKind classKind, @NotNull PsiDirectory rootDir, @NotNull PsiElement contextElement, @Nullable String superClassName) {
        String packageName = StringUtil.getPackageName((String)classFQN);
        int lastDot = classFQN.lastIndexOf(46);
        String className = lastDot >= 0 ? classFQN.substring(lastDot + 1) : classFQN;
        PsiDirectory packageDir = CreateServiceClassFixBase.getOrCreatePackageDirInRoot(packageName, rootDir);
        if (packageDir == null) {
            return null;
        }
        return CreateFromUsageUtils.createClass(classKind, packageDir, className, contextElement.getManager(), contextElement, null, superClassName);
    }

    protected static PsiDirectory[] getModuleRootDirs(Module module) {
        ArrayList roots = new ArrayList();
        JavaProjectRootsUtil.collectSuitableDestinationSourceRoots(module, roots);
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        return (PsiDirectory[])roots.stream().map(arg_0 -> ((PsiManager)psiManager).findDirectory(arg_0)).filter(Objects::nonNull).sorted(Comparator.comparing(psiDir -> psiDir.getVirtualFile().getPresentableUrl())).toArray(PsiDirectory[]::new);
    }

    public static void positionCursor(@Nullable PsiClass psiClass) {
        if (psiClass != null) {
            CodeInsightUtil.positionCursor(psiClass.getProject(), psiClass.getContainingFile(), (PsiElement)psiClass);
        }
    }

    public static class PsiDirectoryListCellRenderer
    extends ListCellRendererWrapper<PsiDirectory> {
        public void customize(JList list, PsiDirectory psiDir, int index, boolean selected, boolean hasFocus) {
            if (psiDir != null) {
                String text2 = ProjectUtil.calcRelativeToProjectPath((VirtualFile)psiDir.getVirtualFile(), (Project)psiDir.getProject(), (boolean)true, (boolean)false, (boolean)true);
                this.setText(text2);
            }
        }
    }
}

