/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateServiceClassFixBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UI;
import java.util.Collections;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateServiceImplementationClassFix
extends CreateServiceClassFixBase {
    private String mySuperClassName;
    private String myImplementationClassName;
    private String myModuleName;

    public CreateServiceImplementationClassFix(PsiJavaCodeReferenceElement referenceElement) {
        this.init(referenceElement);
    }

    private void init(@NotNull PsiJavaCodeReferenceElement referenceElement) {
        PsiProvidesStatement providesStatement;
        PsiElement parent = (referenceElement = CreateServiceImplementationClassFix.findTopmostReference(referenceElement)).getParent();
        if (parent != null && referenceElement.isQualified() && (providesStatement = (PsiProvidesStatement)ObjectUtils.tryCast((Object)parent.getParent(), PsiProvidesStatement.class)) != null && providesStatement.getImplementationList() == parent) {
            PsiClass superClass;
            PsiJavaCodeReferenceElement interfaceReference;
            this.myImplementationClassName = referenceElement.getQualifiedName();
            if (this.myImplementationClassName != null && (interfaceReference = providesStatement.getInterfaceReference()) != null && (superClass = (PsiClass)ObjectUtils.tryCast((Object)interfaceReference.resolve(), PsiClass.class)) != null) {
                this.mySuperClassName = superClass.getQualifiedName();
                if (this.mySuperClassName != null) {
                    this.myModuleName = Optional.of(referenceElement).map(PsiElement::getContainingFile).map(ModuleUtilCore::findModuleForFile).map(Module::getName).orElse(null);
                }
            }
        }
    }

    @Nls
    @NotNull
    public String getText() {
        return QuickFixBundle.message("create.service.implementation.fix.name", this.myImplementationClassName);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.service.implementation.fix.family.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (this.mySuperClassName != null && this.myImplementationClassName != null && this.myModuleName != null) {
            GlobalSearchScope projectScope;
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            return psiFacade.findClass(this.myImplementationClassName, projectScope = GlobalSearchScope.projectScope((Project)project)) == null && psiFacade.findClass(this.mySuperClassName, projectScope) != null && CreateServiceImplementationClassFix.isQualifierInProject(this.myImplementationClassName, project);
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(this.myModuleName);
        if (module != null) {
            PsiDirectory psiRootDir;
            PsiClass outerClass;
            String qualifierText = StringUtil.getPackageName((String)this.myImplementationClassName);
            if (!StringUtil.isEmpty((String)qualifierText) && (outerClass = CreateServiceImplementationClassFix.findClassInModule(qualifierText, module)) != null) {
                this.createClassInOuter(qualifierText, outerClass);
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                PsiDirectory rootDir = (PsiDirectory)file.getUserData(SERVICE_ROOT_DIR);
                Boolean isSubclass = (Boolean)file.getUserData(SERVICE_IS_SUBCLASS);
                if (rootDir != null && isSubclass != null) {
                    WriteAction.run(() -> this.createClassInRoot(rootDir, isSubclass, (PsiElement)file));
                }
                return;
            }
            PsiDirectory[] psiRootDirs = CreateServiceImplementationClassFix.getModuleRootDirs(module);
            CreateServiceImplementationDialog dialog = new CreateServiceImplementationDialog(project, psiRootDirs, this.mySuperClassName);
            if (dialog.showAndGet() && (psiRootDir = dialog.getRootDir()) != null) {
                boolean isSubclass = dialog.isSubclass();
                PsiClass psiClass = (PsiClass)WriteAction.compute(() -> this.createClassInRoot(psiRootDir, isSubclass, (PsiElement)file));
                CreateServiceImplementationClassFix.positionCursor(psiClass);
            }
        }
    }

    private PsiClass createClassInRoot(@NotNull PsiDirectory psiRootDir, boolean isSubclass, @NotNull PsiElement contextElement) {
        Project project = psiRootDir.getProject();
        PsiClass psiImplClass = CreateServiceImplementationClassFix.createClassInRoot(this.myImplementationClassName, CreateClassKind.CLASS, psiRootDir, contextElement, isSubclass ? this.mySuperClassName : null);
        if (psiImplClass != null && !isSubclass) {
            String text2 = "public static " + this.mySuperClassName + " provider() { return null;}";
            PsiMethod method = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(text2, psiImplClass.getLBrace());
            method = (PsiMethod)psiImplClass.addAfter((PsiElement)method, psiImplClass.getLBrace());
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)method);
        }
        return psiImplClass;
    }

    @Nullable
    private static PsiClass findClassInModule(@NotNull String className, @NotNull Module module) {
        Project project = module.getProject();
        ModulesScope scope = new ModulesScope(Collections.singleton(module), project);
        return JavaPsiFacade.getInstance((Project)project).findClass(className, (GlobalSearchScope)scope);
    }

    private void createClassInOuter(String qualifierText, PsiClass outerClass) {
        String name = this.myImplementationClassName.substring(qualifierText.length() + 1);
        PsiClass psiClass = (PsiClass)WriteAction.compute(() -> CreateServiceImplementationClassFix.createClassInOuterImpl(name, outerClass, this.mySuperClassName));
        CreateServiceImplementationClassFix.positionCursor(psiClass);
    }

    private static class CreateServiceImplementationDialog
    extends DialogWrapper {
        private final ComboBoxWithWidePopup<PsiDirectory> myRootDirCombo = new ComboBoxWithWidePopup();
        private final JRadioButton mySubclassButton = new JBRadioButton();
        private final JRadioButton myProviderButton = new JBRadioButton();

        protected CreateServiceImplementationDialog(@Nullable Project project, @NotNull PsiDirectory[] psiRootDirs, @NotNull String superClassName) {
            super(project);
            this.setTitle("Create Service Implementation");
            this.mySubclassButton.setText("Subclass of '" + superClassName + "'");
            this.mySubclassButton.setSelected(true);
            this.myProviderButton.setText("With 'provider()' method");
            ButtonGroup group = new ButtonGroup();
            group.add(this.mySubclassButton);
            group.add(this.myProviderButton);
            this.myRootDirCombo.setRenderer((ListCellRenderer)((Object)new CreateServiceClassFixBase.PsiDirectoryListCellRenderer()));
            this.myRootDirCombo.setModel(new DefaultComboBoxModel<PsiDirectory>(psiRootDirs));
            this.init();
        }

        @NotNull
        protected Action[] createActions() {
            return new Action[]{this.getOKAction(), this.getCancelAction()};
        }

        protected JComponent createCenterPanel() {
            return null;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            PanelGridBuilder builder = UI.PanelFactory.grid();
            builder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.mySubclassButton).withLabel("Implementation:")).add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myProviderButton));
            if (this.myRootDirCombo.getModel().getSize() > 1) {
                builder.add((PanelBuilder)UI.PanelFactory.panel(this.myRootDirCombo).withLabel("Source root:"));
            }
            return builder.createPanel();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.mySubclassButton;
        }

        @Nullable
        public PsiDirectory getRootDir() {
            return (PsiDirectory)this.myRootDirCombo.getSelectedItem();
        }

        public boolean isSubclass() {
            return this.mySubclassButton.isSelected();
        }
    }
}

