/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateTypeParameterFromUsageFix
extends BaseIntentionAction {
    private final SmartPsiElementPointer<PsiJavaCodeReferenceElement> myRef;

    public CreateTypeParameterFromUsageFix(PsiJavaCodeReferenceElement refElement) {
        this.myRef = SmartPointerManager.getInstance((Project)refElement.getProject()).createSmartPsiElementPointer((PsiElement)refElement);
    }

    @Nullable
    private PsiJavaCodeReferenceElement getElement() {
        return (PsiJavaCodeReferenceElement)this.myRef.getElement();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.type.parameter.from.usage.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        boolean available;
        PsiJavaCodeReferenceElement element = this.getElement();
        if (element == null) {
            return false;
        }
        Context context = Context.from(element, true);
        boolean bl = available = context != null;
        if (available) {
            this.setText(QuickFixBundle.message("create.type.parameter.from.usage.text", context.typeName));
        }
        return available;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiJavaCodeReferenceElement element = this.getElement();
        if (element == null) {
            return;
        }
        final Context context = Context.from(element, false);
        if (context == null) {
            return;
        }
        List<PsiNameIdentifierOwner> placesToAdd = context.myPlacesToAdd;
        Application application = ApplicationManager.getApplication();
        if (placesToAdd.size() == 1 || application.isUnitTestMode() || editor == null) {
            PsiElement first = (PsiElement)placesToAdd.get(0);
            CreateTypeParameterFromUsageFix.createTypeParameter(first, context.typeName);
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor, placesToAdd, (Pass)new Pass<PsiNameIdentifierOwner>(){

                public void pass(PsiNameIdentifierOwner owner) {
                    CreateTypeParameterFromUsageFix.createTypeParameter((PsiElement)owner, context.typeName);
                }
            }, PsiNamedElement::getName, (String)QuickFixBundle.message("create.type.parameter.from.usage.chooser.title", new Object[0]));
        }
    }

    private static void createTypeParameter(@NotNull PsiElement methodOrClass, @NotNull String name) {
        Project project = methodOrClass.getProject();
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{methodOrClass})) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            String typeParameterListText;
            PsiTypeParameterListOwner typeParameterListOwner = (PsiTypeParameterListOwner)ObjectUtils.tryCast((Object)methodOrClass, PsiTypeParameterListOwner.class);
            if (typeParameterListOwner == null) {
                throw new IllegalStateException("Only methods and classes allowed here, but was: " + methodOrClass.getClass());
            }
            PsiTypeParameterList typeParameterList = typeParameterListOwner.getTypeParameterList();
            if (typeParameterList == null) {
                typeParameterListText = "<" + name + ">";
            } else {
                String existingTypeParameterText = typeParameterList.getText();
                if (typeParameterList.getTypeParameters().length == 0) {
                    typeParameterListText = "<" + name + ">";
                } else {
                    String prefix = existingTypeParameterText.substring(0, existingTypeParameterText.length() - 1);
                    typeParameterListText = prefix + ", " + name + ">";
                }
            }
            PsiTypeParameterList newTypeParameterList = CreateTypeParameterFromUsageFix.createTypeParameterList(typeParameterListText, project);
            CreateTypeParameterFromUsageFix.replaceOrAddTypeParameterList(methodOrClass, typeParameterList, newTypeParameterList);
        });
    }

    private static void replaceOrAddTypeParameterList(@NotNull PsiElement methodOrClass, @Nullable PsiTypeParameterList typeParameterList, @NotNull PsiTypeParameterList newTypeParameterList) {
        if (methodOrClass instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)methodOrClass;
            if (typeParameterList == null) {
                PsiTypeElement returnTypeElement = method.getReturnTypeElement();
                if (returnTypeElement == null) {
                    return;
                }
                method.addBefore((PsiElement)newTypeParameterList, (PsiElement)returnTypeElement);
            } else {
                typeParameterList.replace((PsiElement)newTypeParameterList);
            }
        } else {
            PsiClass aClass = (PsiClass)methodOrClass;
            if (typeParameterList == null) {
                PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                aClass.addAfter((PsiElement)newTypeParameterList, (PsiElement)nameIdentifier);
            } else {
                typeParameterList.replace((PsiElement)newTypeParameterList);
            }
        }
    }

    private static PsiTypeParameterList createTypeParameterList(@NotNull String text2, Project project) {
        PsiJavaFile javaFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText("_DUMMY_", (FileType)JavaFileType.INSTANCE, (CharSequence)("class __DUMMY__ " + text2 + " {}"));
        PsiClass[] classes2 = javaFile.getClasses();
        return classes2[0].getTypeParameterList();
    }

    static List<PsiNameIdentifierOwner> collectParentClassesAndMethodsUntilStatic(PsiElement element, boolean findFirstOnly) {
        SmartList parents2 = new SmartList();
        for (element = element.getParent(); !(element == null || element instanceof PsiField && ((PsiField)element).hasModifierProperty("static") || element instanceof PsiClass && ((PsiClass)element).isEnum()); element = element.getParent()) {
            if (!(element instanceof PsiMethod) && !CreateTypeParameterFromUsageFix.isValidClass(element)) continue;
            if (((PsiMember)element).getName() != null) {
                parents2.add((PsiNameIdentifierOwner)element);
                if (findFirstOnly) {
                    return parents2;
                }
            }
            if (((PsiModifierListOwner)element).hasModifierProperty("static")) break;
        }
        return parents2;
    }

    private static boolean isValidClass(PsiElement element) {
        return element instanceof PsiClass && !(element instanceof PsiTypeParameter);
    }

    private static class Context {
        @NotNull
        final List<PsiNameIdentifierOwner> myPlacesToAdd;
        @NotNull
        final String typeName;

        Context(@NotNull List<PsiNameIdentifierOwner> add, @NotNull String name) {
            this.myPlacesToAdd = add;
            this.typeName = name;
        }

        @Nullable
        static Context from(@NotNull PsiJavaCodeReferenceElement element, boolean findFirstOnly) {
            if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)element)) {
                return null;
            }
            if (element.isQualified()) {
                return null;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof PsiMethodCallExpression || parent instanceof PsiJavaCodeReferenceElement || parent instanceof PsiNewExpression || parent instanceof PsiTypeElement && parent.getParent() instanceof PsiClassObjectAccessExpression || element instanceof PsiReferenceExpression) {
                return null;
            }
            List<PsiNameIdentifierOwner> candidates = CreateTypeParameterFromUsageFix.collectParentClassesAndMethodsUntilStatic((PsiElement)element, findFirstOnly);
            if (candidates.isEmpty()) {
                return null;
            }
            String name = element.getReferenceName();
            if (name == null) {
                return null;
            }
            return new Context(candidates, name);
        }
    }
}

