/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMethodUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.BringVariableIntoScopeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateConstantFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateEnumConstantFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFieldFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateInnerClassFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateLocalFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateParameterFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateServiceImplementationClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateServiceInterfaceOrClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateTypeParameterFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateVarFromUsageFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveClassToModuleFix;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyStaticConstantFix;
import com.intellij.codeInsight.daemon.impl.quickfix.RenameWrongRefFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportConstantFix;
import com.intellij.codeInsight.daemon.impl.quickfix.SurroundWithQuotesAnnotationParameterValueFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.PriorityIntentionActionWrapper;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.lang.java.request.CreateFieldFromUsage;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        PsiFile containingFile = ref.getContainingFile();
        if (PsiUtil.isModuleFile((PsiFile)containingFile)) {
            OrderEntryFix.registerFixes(registrar, (PsiReference)ref);
            registrar.register((IntentionAction)new CreateServiceImplementationClassFix(ref));
            registrar.register((IntentionAction)new CreateServiceInterfaceOrClassFix(ref));
            return;
        }
        QuickFixFactory quickFixFactory = QuickFixFactory.getInstance();
        registrar.register((IntentionAction)new ImportClassFix(ref));
        registrar.register((IntentionAction)new StaticImportConstantFix(containingFile, ref));
        registrar.register((IntentionAction)new QualifyStaticConstantFix(containingFile, ref));
        registrar.register(quickFixFactory.createSetupJDKFix());
        OrderEntryFix.registerFixes(registrar, (PsiReference)ref);
        MoveClassToModuleFix.registerFixes(registrar, ref);
        if (ref instanceof PsiReferenceExpression) {
            TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)ref);
            PsiReferenceExpression refExpr = (PsiReferenceExpression)ref;
            registrar.register((IntentionAction)new RenameWrongRefFix(refExpr));
            PsiExpression qualifier = ((PsiReferenceExpression)ref).getQualifierExpression();
            if (qualifier == null) {
                registrar.register(fixRange, (IntentionAction)new BringVariableIntoScopeFix(refExpr), null);
            } else {
                AddTypeCastFix.registerFix(registrar, qualifier, ref, fixRange);
            }
            for (IntentionAction action : DefaultQuickFixProvider.createVariableActions(refExpr)) {
                registrar.register(fixRange, action, null);
            }
        }
        registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.INTERFACE));
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)ref)) {
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.ENUM));
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.ANNOTATION));
            registrar.register((IntentionAction)new CreateTypeParameterFromUsageFix(ref));
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiNewExpression.class, PsiMethod.class});
        PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiExpressionList.class);
        if (!(!(parent instanceof PsiNewExpression) || ref.getParent() instanceof PsiTypeElement || expressionList != null && PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)expressionList, (boolean)false))) {
            registrar.register((IntentionAction)new CreateClassFromNewFix((PsiNewExpression)parent));
            registrar.register((IntentionAction)new CreateInnerClassFromNewFix((PsiNewExpression)parent));
        } else {
            registrar.register((IntentionAction)new CreateClassFromUsageFix(ref, CreateClassKind.CLASS));
            registrar.register((IntentionAction)new CreateInnerClassFromUsageFix(ref, CreateClassKind.CLASS));
        }
        SurroundWithQuotesAnnotationParameterValueFix.register(registrar, ref);
    }

    @NotNull
    private static Collection<IntentionAction> createVariableActions(@NotNull PsiReferenceExpression refExpr) {
        ArrayList<IntentionAction> result = new ArrayList<IntentionAction>();
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)refExpr.getProject());
        VariableKind kind2 = DefaultQuickFixProvider.getKind(styleManager, refExpr);
        if (JvmElementActionFactories.useInterlaguageActions()) {
            result.addAll(CreateFieldFromUsage.generateActions(refExpr));
            if (!refExpr.isQualified()) {
                CreateLocalFromUsageFix createLocalFix = new CreateLocalFromUsageFix(refExpr);
                result.add((IntentionAction)(kind2 == VariableKind.LOCAL_VARIABLE ? PriorityIntentionActionWrapper.highPriority((IntentionAction)createLocalFix) : createLocalFix));
                CreateParameterFromUsageFix createParameterFix = new CreateParameterFromUsageFix(refExpr);
                result.add((IntentionAction)(kind2 == VariableKind.PARAMETER ? PriorityIntentionActionWrapper.highPriority((IntentionAction)createParameterFix) : createParameterFix));
            }
            return result;
        }
        EnumMap<VariableKind, CreateVarFromUsageFix> map2 = new EnumMap<VariableKind, CreateVarFromUsageFix>(VariableKind.class);
        map2.put(VariableKind.FIELD, new CreateFieldFromUsageFix(refExpr));
        map2.put(VariableKind.STATIC_FINAL_FIELD, new CreateConstantFieldFromUsageFix(refExpr));
        if (!refExpr.isQualified()) {
            map2.put(VariableKind.LOCAL_VARIABLE, new CreateLocalFromUsageFix(refExpr));
            map2.put(VariableKind.PARAMETER, new CreateParameterFromUsageFix(refExpr));
        }
        if (map2.containsKey(kind2)) {
            map2.put(kind2, (CreateVarFromUsageFix)PriorityIntentionActionWrapper.highPriority((IntentionAction)((IntentionAction)map2.get(kind2))));
        }
        result.add((IntentionAction)new CreateEnumConstantFromUsageFix(refExpr));
        result.addAll(map2.values());
        return result;
    }

    @Nullable
    private static VariableKind getKind(@NotNull JavaCodeStyleManager styleManager, @NotNull PsiReferenceExpression refExpr) {
        String reference = refExpr.getText();
        if (StringUtil.isUpperCase((CharSequence)reference)) {
            return VariableKind.STATIC_FINAL_FIELD;
        }
        for (VariableKind kind2 : VariableKind.values()) {
            String prefix = styleManager.getPrefixByVariableKind(kind2);
            String suffix = styleManager.getSuffixByVariableKind(kind2);
            if (prefix.isEmpty() && suffix.isEmpty() || !reference.startsWith(prefix) || !reference.endsWith(suffix)) continue;
            return kind2;
        }
        if (StringUtil.isCapitalized((String)reference)) {
            return null;
        }
        return VariableKind.LOCAL_VARIABLE;
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        return PsiJavaCodeReferenceElement.class;
    }
}

