/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeleteMultiCatchFix
implements IntentionAction {
    private final PsiTypeElement myTypeElement;

    public DeleteMultiCatchFix(@NotNull PsiTypeElement typeElement) {
        this.myTypeElement = typeElement;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("delete.catch.text", JavaHighlightUtil.formatType(this.myTypeElement.getType()));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("delete.catch.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myTypeElement.isValid() && BaseIntentionAction.canModify((PsiElement)this.myTypeElement);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.myTypeElement;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        DeleteMultiCatchFix.deleteCaughtExceptionType(this.myTypeElement);
    }

    public static void deleteCaughtExceptionType(@NotNull PsiTypeElement typeElement) {
        PsiElement last;
        PsiTypeElement first;
        PsiElement parentType = typeElement.getParent();
        if (!(parentType instanceof PsiTypeElement)) {
            return;
        }
        PsiElement right = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)typeElement);
        if (PsiUtil.isJavaToken((PsiElement)right, (IElementType)JavaTokenType.OR)) {
            first = typeElement;
            last = right;
        } else if (right == null) {
            PsiElement left = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)typeElement);
            if (!(left instanceof PsiJavaToken)) {
                return;
            }
            IElementType leftType = ((PsiJavaToken)left).getTokenType();
            if (leftType != JavaTokenType.OR) {
                return;
            }
            first = left;
            last = typeElement;
        } else {
            return;
        }
        parentType.deleteChildRange((PsiElement)first, last);
        List typeElements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)parentType, PsiTypeElement.class);
        if (typeElements.size() == 1) {
            PsiElement parameter2 = parentType.getParent();
            parameter2.addRangeAfter(parentType.getFirstChild(), parentType.getLastChild(), parentType);
            parentType.delete();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

