/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class GeneralizeCatchFix
implements IntentionAction {
    private final PsiElement myElement;
    private final PsiClassType myUnhandledException;
    private PsiTryStatement myTryStatement;
    private PsiParameter myCatchParameter;

    public GeneralizeCatchFix(@NotNull PsiElement element, @NotNull PsiClassType unhandledException) {
        this.myElement = element;
        this.myUnhandledException = unhandledException;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("generalize.catch.text", JavaHighlightUtil.formatType(this.myCatchParameter == null ? null : this.myCatchParameter.getType()), JavaHighlightUtil.formatType((PsiType)this.myUnhandledException));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("generalize.catch.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiParameter[] catchBlockParameters;
        if (!(this.myElement.isValid() && this.myUnhandledException.isValid() && BaseIntentionAction.canModify((PsiElement)this.myElement))) {
            return false;
        }
        for (PsiElement element = this.myElement; element != null; element = element.getParent()) {
            if (PsiUtil.isTryBlock((PsiElement)element) || element instanceof PsiResourceList) {
                this.myTryStatement = (PsiTryStatement)element.getParent();
                break;
            }
            if (element instanceof PsiMethod || element instanceof PsiFunctionalExpression || element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) break;
        }
        if (this.myTryStatement == null) {
            return false;
        }
        for (PsiParameter catchBlockParameter : catchBlockParameters = this.myTryStatement.getCatchBlockParameters()) {
            PsiType type2 = catchBlockParameter.getType();
            if (!this.myUnhandledException.isAssignableFrom(type2)) continue;
            this.myCatchParameter = catchBlockParameter;
            break;
        }
        return this.myCatchParameter != null;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.myElement;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myElement.getProject());
        PsiTypeElement type2 = factory.createTypeElement((PsiType)this.myUnhandledException);
        this.myCatchParameter.getTypeElement().replace((PsiElement)type2);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

