/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.actions.TypeCookAction;
import org.jetbrains.annotations.NotNull;

public class GenerifyFileFix
implements IntentionAction,
LocalQuickFix {
    private String myFileName;

    @NotNull
    public String getText() {
        return QuickFixBundle.message("generify.text", this.myFileName);
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("generify.family", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        PsiFile file = element.getContainingFile();
        if (this.isAvailable(project, null, file)) {
            this.myFileName = file.getName();
            WriteCommandAction.writeCommandAction((Project)project).run(() -> this.invoke(project, FileEditorManager.getInstance((Project)project).getSelectedTextEditor(), file));
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (file != null && file.isValid()) {
            this.myFileName = file.getName();
            return BaseIntentionAction.canModify((PsiElement)file);
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        new TypeCookAction().getHandler().invoke(project, editor, file, null);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

