/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.MergePackageAccessibilityStatementsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeProvidesStatementsFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeModuleStatementsFix<T extends PsiStatement>
extends LocalQuickFixAndIntentionActionOnPsiElement {
    protected MergeModuleStatementsFix(@NotNull PsiJavaModule javaModule) {
        super((PsiElement)javaModule);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return PsiUtil.isLanguageLevel9OrHigher((PsiElement)file);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (startElement instanceof PsiJavaModule) {
            PsiJavaModule javaModule = (PsiJavaModule)startElement;
            List<T> statementsToMerge = this.getStatementsToMerge(javaModule);
            LOG.assertTrue(!statementsToMerge.isEmpty());
            String text2 = this.getReplacementText(statementsToMerge);
            PsiStatement replacement = JavaPsiFacade.getElementFactory((Project)project).createModuleStatementFromText(text2, null);
            PsiStatement firstStatement = (PsiStatement)statementsToMerge.get(0);
            CommentTracker commentTracker = new CommentTracker();
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            PsiElement resultingStatement = codeStyleManager.reformat(commentTracker.replace((PsiElement)firstStatement, (PsiElement)replacement));
            for (int i = 1; i < statementsToMerge.size(); ++i) {
                PsiStatement statement = (PsiStatement)statementsToMerge.get(i);
                commentTracker.delete((PsiElement)statement);
            }
            commentTracker.insertCommentsBefore(resultingStatement);
            if (editor != null) {
                int offset = resultingStatement.getTextRange().getEndOffset();
                editor.getCaretModel().moveToOffset(offset);
            }
        }
    }

    @NotNull
    protected abstract String getReplacementText(List<? extends T> var1);

    @NotNull
    protected abstract List<T> getStatementsToMerge(@NotNull PsiJavaModule var1);

    @NotNull
    protected static String joinUniqueNames(@NotNull List<String> names) {
        THashSet unique = new THashSet();
        return names.stream().filter(arg_0 -> MergeModuleStatementsFix.lambda$joinUniqueNames$0((Set)unique, arg_0)).collect(Collectors.joining(","));
    }

    @Nullable
    public static MergeModuleStatementsFix createFix(@Nullable PsiElement statement) {
        if (statement instanceof PsiPackageAccessibilityStatement) {
            return MergePackageAccessibilityStatementsFix.createFix((PsiPackageAccessibilityStatement)statement);
        }
        if (statement instanceof PsiProvidesStatement) {
            return MergeProvidesStatementsFix.createFix((PsiProvidesStatement)statement);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$joinUniqueNames$0(Set unique, String name) {
        return unique.add(name);
    }
}

