/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeModuleStatementsFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergePackageAccessibilityStatementsFix
extends MergeModuleStatementsFix<PsiPackageAccessibilityStatement> {
    private static final Logger LOG = Logger.getInstance(MergePackageAccessibilityStatementsFix.class);
    private final String myPackageName;
    private final PsiPackageAccessibilityStatement.Role myRole;

    protected MergePackageAccessibilityStatementsFix(@NotNull PsiJavaModule javaModule, @NotNull String packageName, @NotNull PsiPackageAccessibilityStatement.Role role) {
        super(javaModule);
        this.myPackageName = packageName;
        this.myRole = role;
    }

    @Nls
    @NotNull
    public String getText() {
        return QuickFixBundle.message("java.9.merge.module.statements.fix.name", this.getKeyword(), this.myPackageName);
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("java.9.merge.module.statements.fix.family.name", this.getKeyword());
    }

    @Override
    @NotNull
    protected String getReplacementText(@NotNull List<? extends PsiPackageAccessibilityStatement> statementsToMerge) {
        List<String> moduleNames = MergePackageAccessibilityStatementsFix.getModuleNames(statementsToMerge);
        if (!moduleNames.isEmpty()) {
            return this.getKeyword() + ' ' + this.myPackageName + ' ' + "to" + ' ' + MergePackageAccessibilityStatementsFix.joinUniqueNames(moduleNames);
        }
        return this.getKeyword() + ' ' + this.myPackageName;
    }

    @NotNull
    private static List<String> getModuleNames(@NotNull List<? extends PsiPackageAccessibilityStatement> statements) {
        ArrayList<String> result = new ArrayList<String>();
        for (PsiPackageAccessibilityStatement psiPackageAccessibilityStatement : statements) {
            List moduleNames = psiPackageAccessibilityStatement.getModuleNames();
            if (moduleNames.isEmpty()) {
                return Collections.emptyList();
            }
            result.addAll(moduleNames);
        }
        return result;
    }

    @Override
    @NotNull
    protected List<PsiPackageAccessibilityStatement> getStatementsToMerge(@NotNull PsiJavaModule javaModule) {
        return ((StreamEx)StreamEx.of(MergePackageAccessibilityStatementsFix.getStatements(javaModule, this.myRole).iterator()).filter(statement -> this.myPackageName.equals(statement.getPackageName()))).toList();
    }

    @Nullable
    public static MergeModuleStatementsFix createFix(@Nullable PsiPackageAccessibilityStatement statement) {
        String packageName;
        PsiElement parent;
        if (statement != null && (parent = statement.getParent()) instanceof PsiJavaModule && (packageName = statement.getPackageName()) != null) {
            return new MergePackageAccessibilityStatementsFix((PsiJavaModule)parent, packageName, statement.getRole());
        }
        return null;
    }

    @NotNull
    private static Iterable<PsiPackageAccessibilityStatement> getStatements(@NotNull PsiJavaModule javaModule, @NotNull PsiPackageAccessibilityStatement.Role role) {
        switch (role) {
            case OPENS: {
                return javaModule.getOpens();
            }
            case EXPORTS: {
                return javaModule.getExports();
            }
        }
        LOG.error("Unexpected role " + role);
        return Collections.emptyList();
    }

    @NotNull
    private String getKeyword() {
        switch (this.myRole) {
            case OPENS: {
                return "opens";
            }
            case EXPORTS: {
                return "exports";
            }
        }
        LOG.error("Unexpected role " + this.myRole);
        return "";
    }
}

