/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReturnFixFactory
extends ArgumentFixerActionFactory {
    public static final ArgumentFixerActionFactory INSTANCE = new MethodReturnFixFactory();

    private MethodReturnFixFactory() {
    }

    @Override
    @Nullable
    protected PsiExpression getModifiedArgument(PsiExpression expression2, PsiType toType) throws IncorrectOperationException {
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiMethodCallExpression.class);
        if (call == null) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiType type2 = GenericsUtil.getVariableTypeByExpressionType((PsiType)toType);
        return JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText("(" + type2.getCanonicalText() + ")null", (PsiElement)expression2);
    }

    @Override
    public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
        return !PsiType.VOID.equals((Object)exprType) && exprType.equalsToText(exprType.getCanonicalText());
    }

    @Override
    public IntentionAction createFix(PsiExpressionList list, int i, PsiType toType) {
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)list.getExpressions()[i]), PsiMethodCallExpression.class);
        if (call == null) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiReferenceExpression ref = call.getMethodExpression();
        if (ReferencesSearch.search((PsiElement)method, (SearchScope)new LocalSearchScope((PsiElement)list)).anyMatch(r -> r != ref)) {
            return null;
        }
        return QuickFixFactory.getInstance().createMethodReturnFix(method, toType, true);
    }
}

