/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModifierFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.quickfix.ModifierFix");
    @PsiModifier.ModifierConstant
    private final String myModifier;
    private final boolean myShouldHave;
    private final boolean myShowContainingClass;
    private volatile String myName;
    private final SmartPsiElementPointer<PsiVariable> myVariable;

    public ModifierFix(PsiModifierList modifierList, @PsiModifier.ModifierConstant @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        super((PsiElement)modifierList);
        this.myModifier = modifier;
        this.myShouldHave = shouldHave;
        this.myShowContainingClass = showContainingClass;
        this.myName = this.format(null, modifierList, this.myShowContainingClass);
        this.myVariable = null;
    }

    public ModifierFix(@NotNull PsiModifierListOwner owner, @PsiModifier.ModifierConstant @NotNull String modifier, boolean shouldHave, boolean showContainingClass) {
        super((PsiElement)owner.getModifierList());
        this.myModifier = modifier;
        this.myShouldHave = shouldHave;
        this.myShowContainingClass = showContainingClass;
        PsiVariable variable = owner instanceof PsiVariable ? (PsiVariable)owner : null;
        this.myName = this.format(variable, owner.getModifierList(), this.myShowContainingClass);
        this.myVariable = variable == null ? null : SmartPointerManager.getInstance((Project)owner.getProject()).createSmartPsiElementPointer((PsiElement)variable);
    }

    private String format(PsiVariable variable, PsiModifierList modifierList, boolean showContainingClass) {
        PsiVariable parent;
        String name = null;
        Object object = variable != null ? variable : (parent = modifierList != null ? modifierList.getParent() : null);
        if (parent instanceof PsiClass) {
            name = ((PsiClass)parent).getName();
        } else if (parent instanceof PsiJavaModule) {
            name = ((PsiJavaModule)parent).getName();
        } else if (parent instanceof PsiMethod) {
            int options = 1 | (showContainingClass ? 4096 : 0);
            name = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)parent), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)0);
        } else if (parent instanceof PsiVariable) {
            int options = 1 | (showContainingClass ? 4096 : 0);
            name = PsiFormatUtil.formatVariable((PsiVariable)parent, (int)options, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        } else if (parent instanceof PsiClassInitializer) {
            PsiClass containingClass = ((PsiClassInitializer)parent).getContainingClass();
            String className = containingClass instanceof PsiAnonymousClass ? QuickFixBundle.message("anonymous.class.presentation", ((PsiAnonymousClass)containingClass).getBaseClassType().getPresentableText()) : (containingClass != null ? containingClass.getName() : "unknown");
            name = QuickFixBundle.message("class.initializer.presentation", className);
        } else if (parent instanceof PsiRequiresStatement) {
            name = "requires " + ((PsiRequiresStatement)parent).getModuleName();
        }
        String modifierText = VisibilityUtil.toPresentableText((String)this.myModifier);
        return QuickFixBundle.message(this.myShouldHave ? "add.modifier.fix" : "remove.modifier.fix", name, modifierText);
    }

    @NotNull
    public String getText() {
        return this.myName;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("fix.modifiers.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiElement elementUnderCaret;
        boolean isAvailable;
        PsiModifierList modifierList = (PsiModifierList)startElement;
        PsiVariable variable = this.myVariable == null ? null : (PsiVariable)this.myVariable.getElement();
        boolean bl = isAvailable = BaseIntentionAction.canModify((PsiElement)modifierList) && modifierList.hasExplicitModifier(this.myModifier) != this.myShouldHave && (variable == null || variable.isValid());
        if (isAvailable && this.myShowContainingClass && editor != null && (elementUnderCaret = file.findElementAt(editor.getCaretModel().getOffset())) != null && PsiTreeUtil.isAncestor((PsiElement)modifierList.getParent(), (PsiElement)elementUnderCaret, (boolean)false)) {
            this.myName = this.format(variable, modifierList, false);
        }
        return isAvailable;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return this.isAvailable(project, file, null, startElement, endElement);
    }

    private void changeModifierList(@NotNull PsiModifierList modifierList) {
        try {
            modifierList.setModifierProperty(this.myModifier, this.myShouldHave);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiModifierList modifierList;
        PsiVariable variable;
        PsiVariable psiVariable = variable = this.myVariable == null ? null : (PsiVariable)this.myVariable.getElement();
        if (variable != null && variable.isValid()) {
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)variable)) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    variable.normalizeDeclaration();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
            modifierList = variable.getModifierList();
            assert (modifierList != null);
        } else {
            modifierList = (PsiModifierList)startElement;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)modifierList)) {
            return;
        }
        PsiElement owner = modifierList.getParent();
        if (owner instanceof PsiMethod) {
            PsiModifierList copy = (PsiModifierList)modifierList.copy();
            this.changeModifierList(copy);
            final int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)copy);
            if (accessLevel != PsiUtil.getAccessLevel((PsiModifierList)modifierList)) {
                final ArrayList modifierLists = new ArrayList();
                ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> OverridingMethodsSearch.search((PsiMethod)((PsiMethod)owner), (SearchScope)owner.getResolveScope(), (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)new PsiElementProcessor<PsiMethod>(){

                    public boolean execute(@NotNull PsiMethod inheritor) {
                        PsiModifierList list = inheritor.getModifierList();
                        if (BaseIntentionAction.canModify((PsiElement)inheritor) && PsiUtil.getAccessLevel((PsiModifierList)list) < accessLevel) {
                            modifierLists.add(list);
                        }
                        return true;
                    }
                })), InspectionsBundle.message((String)"psi.search.overriding.progress", (Object[])new Object[0]), true, project);
                if (!modifierLists.isEmpty() && Messages.showYesNoDialog((Project)project, (String)QuickFixBundle.message("change.inheritors.visibility.warning.text", new Object[0]), (String)QuickFixBundle.message("change.inheritors.visibility.warning.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (!FileModificationService.getInstance().preparePsiElementsForWrite((Collection)modifierLists)) {
                            return;
                        }
                        for (PsiModifierList modifierList1 : modifierLists) {
                            this.changeModifierList(modifierList1);
                        }
                    });
                }
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.changeModifierList(modifierList);
            if (this.myShouldHave && owner instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)owner;
                if ("abstract".equals(this.myModifier)) {
                    PsiModifierList classModifierList;
                    PsiClass aClass = method.getContainingClass();
                    if (aClass != null && !aClass.hasModifierProperty("abstract") && (classModifierList = aClass.getModifierList()) != null) {
                        this.changeModifierList(classModifierList);
                    }
                } else if ("public".equals(this.myModifier) && method.getBody() != null && !method.hasModifierProperty("static")) {
                    PsiClass containingClass = method.getContainingClass();
                    if (containingClass != null && containingClass.isInterface()) {
                        modifierList.setModifierProperty("default", true);
                    }
                } else if ("static".equals(this.myModifier)) {
                    if (method.hasModifierProperty("default")) {
                        modifierList.setModifierProperty("default", false);
                    } else if (method.hasModifierProperty("abstract")) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)false);
                        CreateFromUsageUtils.setupMethodBody(method);
                    }
                }
            }
            UndoUtil.markPsiFileForUndo((PsiFile)modifierList.getContainingFile());
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

