/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.file.JavaDirectoryServiceImpl;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveClassToSeparateFileFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(MoveClassToSeparateFileFix.class);
    private final PsiClass myClass;

    public MoveClassToSeparateFileFix(@NotNull PsiClass aClass) {
        this.myClass = aClass;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("move.class.to.separate.file.text", this.myClass.getName());
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("move.class.to.separate.file.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        if (!this.myClass.isValid() || !BaseIntentionAction.canModify((PsiElement)this.myClass)) {
            return false;
        }
        PsiDirectory dir = file.getContainingDirectory();
        if (dir == null) {
            return false;
        }
        try {
            JavaDirectoryServiceImpl.checkCreateClassOrInterface(dir, this.myClass.getName());
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return true;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.myClass;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        PsiDirectory dir = file.getContainingDirectory();
        String name = this.myClass.getName();
        JavaDirectoryService directoryService = JavaDirectoryService.getInstance();
        PsiClass placeHolder = this.myClass.isInterface() ? directoryService.createInterface(dir, name) : directoryService.createClass(dir, name);
        WriteAction.run(() -> {
            PsiClass newClass = (PsiClass)placeHolder.replace((PsiElement)this.myClass);
            this.myClass.delete();
            Navigatable descriptor = PsiNavigationSupport.getInstance().createNavigatable(project, newClass.getContainingFile().getVirtualFile(), newClass.getTextOffset());
            descriptor.navigate(true);
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

