/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MoveFileFix
implements IntentionAction {
    private final VirtualFile myFile;
    private final VirtualFile myTarget;
    private final String myMessage;

    public MoveFileFix(@NotNull VirtualFile file, @NotNull VirtualFile target, @NotNull @Nls String message2) {
        this.myFile = file;
        this.myTarget = target;
        this.myMessage = message2;
    }

    @Nls
    @NotNull
    public String getText() {
        return this.myMessage;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (this.myFile.isValid() && this.myTarget.isValid()) {
            try {
                this.myFile.move((Object)this, this.myTarget);
            }
            catch (IOException e) {
                throw new IncorrectOperationException("Cannot move '" + this.myFile.getPath() + "' into '" + this.myTarget.getPath() + "'", (Throwable)e);
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

