/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class NegationBroadScopeFix
implements IntentionAction {
    private final PsiPrefixExpression myPrefixExpression;

    public NegationBroadScopeFix(@NotNull PsiPrefixExpression prefixExpression) {
        this.myPrefixExpression = prefixExpression;
    }

    @NotNull
    public String getText() {
        String rop;
        PsiExpression operand2 = this.myPrefixExpression.getOperand();
        String text2 = operand2 == null ? "" : operand2.getText() + " ";
        PsiElement parent = this.myPrefixExpression.getParent();
        if (parent instanceof PsiInstanceOfExpression) {
            text2 = text2 + "instanceof ";
            PsiTypeElement type2 = ((PsiInstanceOfExpression)parent).getCheckType();
            rop = type2 == null ? "" : type2.getText();
        } else if (parent instanceof PsiBinaryExpression) {
            text2 = text2 + ((PsiBinaryExpression)parent).getOperationSign().getText() + " ";
            PsiExpression rOperand = ((PsiBinaryExpression)parent).getROperand();
            rop = rOperand == null ? "" : rOperand.getText();
        } else {
            rop = "<expr>";
        }
        text2 = text2 + rop;
        return QuickFixBundle.message("negation.broader.scope.text", text2);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("negation.broader.scope.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!this.myPrefixExpression.isValid() || this.myPrefixExpression.getOperand() == null) {
            return false;
        }
        PsiElement parent = this.myPrefixExpression.getParent();
        if (parent instanceof PsiInstanceOfExpression && ((PsiInstanceOfExpression)parent).getOperand() == this.myPrefixExpression) {
            return true;
        }
        if (!(parent instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
        return binaryExpression.getLOperand() == this.myPrefixExpression && TypeConversionUtil.isBooleanType((PsiType)binaryExpression.getType());
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.myPrefixExpression;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (!this.isAvailable(project, editor, file)) {
            return;
        }
        PsiExpression operand2 = this.myPrefixExpression.getOperand();
        PsiElement unnegated = this.myPrefixExpression.replace((PsiElement)operand2);
        PsiElement parent = unnegated.getParent();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)file.getProject());
        PsiPrefixExpression negated = (PsiPrefixExpression)factory.createExpressionFromText("!(xxx)", parent);
        PsiParenthesizedExpression parentheses = (PsiParenthesizedExpression)negated.getOperand();
        parentheses.getExpression().replace(parent.copy());
        parent.replace((PsiElement)negated);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

