/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.RunRefactoringAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.extractInterface.ExtractInterfaceHandler;
import com.intellij.refactoring.extractSuperclass.ExtractSuperclassHandler;
import com.intellij.refactoring.memberPullUp.JavaPullUpHandler;
import com.intellij.refactoring.memberPullUp.PullUpProcessor;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PullAsAbstractUpFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(PullAsAbstractUpFix.class);
    private final String myName;

    public PullAsAbstractUpFix(PsiMethod psiMethod, String name) {
        super((PsiElement)psiMethod);
        this.myName = name;
    }

    @NotNull
    public String getText() {
        return this.myName;
    }

    @NotNull
    public String getFamilyName() {
        return "Pull up";
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return startElement instanceof PsiMethod && ((PsiMethod)startElement).getContainingClass() != null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        final PsiMethod method = (PsiMethod)startElement;
        if (!FileModificationService.getInstance().prepareFileForWrite(method.getContainingFile())) {
            return;
        }
        final PsiClass containingClass = method.getContainingClass();
        LOG.assertTrue(containingClass != null);
        PsiManager manager = containingClass.getManager();
        if (containingClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)containingClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass != null && BaseIntentionAction.canModify((PsiElement)baseClass)) {
                PullAsAbstractUpFix.pullUp(method, containingClass, baseClass);
            }
        } else {
            LinkedHashSet classesToPullUp = new LinkedHashSet();
            PullAsAbstractUpFix.collectClassesToPullUp(manager, classesToPullUp, containingClass.getExtendsListTypes());
            PullAsAbstractUpFix.collectClassesToPullUp(manager, classesToPullUp, containingClass.getImplementsListTypes());
            if (classesToPullUp.isEmpty()) {
                new ExtractInterfaceHandler().invoke(project, new PsiElement[]{containingClass}, null);
            } else if (classesToPullUp.size() == 1) {
                PullAsAbstractUpFix.pullUp(method, containingClass, (PsiClass)classesToPullUp.iterator().next());
            } else if (editor != null) {
                NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])classesToPullUp.toArray(PsiClass.EMPTY_ARRAY)), (PsiElementListCellRenderer)new PsiClassListCellRenderer(), (String)"Choose super class", (PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                    public boolean execute(@NotNull PsiClass aClass) {
                        PullAsAbstractUpFix.pullUp(method, containingClass, aClass);
                        return false;
                    }
                }, (PsiElement)((PsiElement)classesToPullUp.iterator().next())).showInBestPositionFor(editor);
            }
        }
    }

    private static void collectClassesToPullUp(PsiManager manager, LinkedHashSet<? super PsiClass> classesToPullUp, PsiClassType[] extendsListTypes) {
        for (PsiClassType extendsListType : extendsListTypes) {
            PsiClass resolve = extendsListType.resolve();
            if (resolve == null || !BaseIntentionAction.canModify((PsiElement)resolve)) continue;
            classesToPullUp.add((PsiClass)resolve);
        }
    }

    private static void pullUp(PsiMethod method, PsiClass containingClass, PsiClass baseClass) {
        if (!FileModificationService.getInstance().prepareFileForWrite(baseClass.getContainingFile())) {
            return;
        }
        MemberInfo memberInfo = new MemberInfo((PsiMember)method);
        memberInfo.setChecked(true);
        memberInfo.setToAbstract(true);
        new PullUpProcessor(containingClass, baseClass, new MemberInfo[]{memberInfo}, new DocCommentPolicy(0)).run();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static void registerQuickFix(@NotNull PsiMethod methodWithOverrides, @NotNull QuickFixActionRegistrar registrar) {
        PsiClass containingClass = methodWithOverrides.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiManager manager = containingClass.getManager();
        boolean canBePulledUp = true;
        String name = "Pull method '" + methodWithOverrides.getName() + "' up";
        if (containingClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)containingClass).getBaseClassType();
            PsiClass baseClass = baseClassType.resolve();
            if (baseClass == null) {
                return;
            }
            if (!BaseIntentionAction.canModify((PsiElement)baseClass)) {
                return;
            }
            if (!baseClass.hasModifierProperty("abstract")) {
                name = "Pull method '" + methodWithOverrides.getName() + "' up and make it abstract";
            }
        } else {
            LinkedHashSet classesToPullUp = new LinkedHashSet();
            PullAsAbstractUpFix.collectClassesToPullUp(manager, classesToPullUp, containingClass.getExtendsListTypes());
            PullAsAbstractUpFix.collectClassesToPullUp(manager, classesToPullUp, containingClass.getImplementsListTypes());
            if (classesToPullUp.isEmpty()) {
                name = "Extract method '" + methodWithOverrides.getName() + "' to new interface";
                canBePulledUp = false;
            } else if (classesToPullUp.size() == 1) {
                PsiClass baseClass = (PsiClass)classesToPullUp.iterator().next();
                name = "Pull method '" + methodWithOverrides.getName() + "' to '" + baseClass.getName() + "'";
                if (!baseClass.hasModifierProperty("abstract")) {
                    name = name + " and make it abstract";
                }
            }
            registrar.register((IntentionAction)new RunRefactoringAction(new ExtractInterfaceHandler(), "Extract interface"));
            registrar.register((IntentionAction)new RunRefactoringAction((RefactoringActionHandler)new ExtractSuperclassHandler(), "Extract superclass"));
        }
        if (canBePulledUp) {
            registrar.register((IntentionAction)new RunRefactoringAction(new JavaPullUpHandler(), "Pull members up"));
        }
        registrar.register((IntentionAction)new PullAsAbstractUpFix(methodWithOverrides, name));
    }
}

