/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QualifyStaticMethodCallFix
extends StaticImportMethodFix {
    public QualifyStaticMethodCallFix(@NotNull PsiFile file, @NotNull PsiMethodCallExpression methodCallExpression) {
        super(file, methodCallExpression);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        return "Qualify static call";
    }

    @Override
    @NotNull
    protected StaticImportMethodQuestionAction<PsiMethod> createQuestionAction(@NotNull List<? extends PsiMethod> methodsToImport, final @NotNull Project project, Editor editor) {
        return new StaticImportMethodQuestionAction<PsiMethod>(project, editor, methodsToImport, this.myRef){

            @Override
            protected void doImport(PsiMethod toImport) {
                PsiMethodCallExpression element = (PsiMethodCallExpression)QualifyStaticMethodCallFix.this.myRef.getElement();
                if (element == null) {
                    return;
                }
                QualifyStaticMethodCallFix.qualifyStatically((PsiMember)toImport, project, element.getMethodExpression());
            }
        };
    }

    @Override
    protected boolean toAddStaticImports() {
        return false;
    }

    static void qualifyStatically(@NotNull PsiMember toImport, @NotNull Project project, @NotNull PsiReferenceExpression qualifiedExpression) {
        PsiClass containingClass = toImport.getContainingClass();
        if (containingClass == null) {
            return;
        }
        PsiReferenceExpression qualifier = JavaPsiFacade.getElementFactory((Project)project).createReferenceExpression(containingClass);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)"Qualify Static Access", null, () -> {
            qualifiedExpression.setQualifierExpression((PsiExpression)qualifier);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)qualifiedExpression);
        }, (PsiFile[])new PsiFile[0]);
    }
}

