/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class QualifyThisOrSuperArgumentFix
implements IntentionAction {
    protected static final Logger LOG = Logger.getInstance(QualifyThisOrSuperArgumentFix.class);
    protected final PsiExpression myExpression;
    protected final PsiClass myPsiClass;
    private String myText;

    public QualifyThisOrSuperArgumentFix(@NotNull PsiExpression expression2, @NotNull PsiClass psiClass) {
        this.myExpression = expression2;
        this.myPsiClass = psiClass;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    protected abstract String getQualifierText();

    protected abstract PsiExpression getQualifier(PsiManager var1);

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!this.myExpression.isValid()) {
            return false;
        }
        if (!this.myPsiClass.isValid()) {
            return false;
        }
        this.myText = "Qualify " + this.getQualifierText() + " expression with '" + this.myPsiClass.getQualifiedName() + "'";
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return "Qualify " + this.getQualifierText();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.myExpression.replace((PsiElement)this.getQualifier(PsiManager.getInstance((Project)project)));
    }
}

