/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveUnusedVariableUtil {
    @Contract(value="_, _, null -> false; null, _, _ -> false")
    public static boolean checkSideEffects(PsiExpression element, @Nullable PsiVariable variableToIgnore, List<? super PsiElement> sideEffects) {
        if (sideEffects == null || element == null) {
            return false;
        }
        ArrayList writes = new ArrayList();
        Predicate<PsiElement> allowedSideEffect = variableToIgnore == null ? e -> false : e -> e instanceof PsiAssignmentExpression && ExpressionUtils.isReferenceTo(((PsiAssignmentExpression)e).getLExpression(), variableToIgnore);
        SideEffectChecker.checkSideEffects(element, writes, allowedSideEffect);
        sideEffects.addAll(writes);
        return !writes.isEmpty();
    }

    public static PsiElement replaceElementWithExpression(PsiExpression expression2, PsiElementFactory factory, PsiElement element) throws IncorrectOperationException {
        PsiElement elementToReplace = element;
        PsiExpression expressionToReplaceWith = expression2;
        if (element.getParent() instanceof PsiExpressionStatement || element.getParent() instanceof PsiExpressionListStatement) {
            PsiElement lastChild;
            elementToReplace = element.getParent();
            expressionToReplaceWith = factory.createStatementFromText((expression2 == null ? "" : expression2.getText()) + ";", null);
            if (RemoveUnusedVariableUtil.isForLoopUpdate(elementToReplace) && PsiUtil.isJavaToken((PsiElement)(lastChild = expressionToReplaceWith.getLastChild()), (IElementType)JavaTokenType.SEMICOLON)) {
                lastChild.delete();
            }
        } else if (element.getParent() instanceof PsiDeclarationStatement) {
            expressionToReplaceWith = factory.createStatementFromText((expression2 == null ? "" : expression2.getText()) + ";", null);
        }
        return elementToReplace.replace((PsiElement)expressionToReplaceWith);
    }

    static PsiElement createStatementIfNeeded(PsiExpression expression2, PsiElementFactory factory, PsiElement element) throws IncorrectOperationException {
        String replacement;
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiExpressionStatement) && !(parent instanceof PsiDeclarationStatement)) {
            return expression2;
        }
        if (expression2 == null) {
            boolean needBlock = parent instanceof PsiExpressionStatement && parent.getParent() instanceof PsiSwitchLabeledRuleStatement;
            replacement = needBlock ? "{}" : ";";
        } else {
            replacement = expression2.getText() + ";";
        }
        return factory.createStatementFromText(replacement, null);
    }

    static void deleteWholeStatement(PsiElement element, PsiElementFactory factory) throws IncorrectOperationException {
        PsiElement parent = element.getParent();
        if (parent instanceof PsiExpressionStatement) {
            if (parent.getParent() instanceof PsiCodeBlock || RemoveUnusedVariableUtil.isForLoopUpdate(parent)) {
                parent.delete();
            } else {
                parent.replace(RemoveUnusedVariableUtil.createStatementIfNeeded(null, factory, element));
            }
        } else if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiExpressionListStatement) {
            PsiExpressionList list = (PsiExpressionList)parent;
            PsiExpression[] expressions2 = list.getExpressions();
            if (expressions2.length == 2) {
                PsiExpression other = expressions2[0] == element ? expressions2[1] : expressions2[0];
                RemoveUnusedVariableUtil.replaceElementWithExpression(other, factory, parent);
            } else {
                element.delete();
            }
        } else if (element.getParent() instanceof PsiLambdaExpression) {
            element.replace((PsiElement)factory.createCodeBlock());
        } else {
            element.delete();
        }
    }

    static void deleteReferences(PsiVariable variable, List<? extends PsiElement> references, @NotNull RemoveMode mode) throws IncorrectOperationException {
        for (PsiElement psiElement : references) {
            RemoveUnusedVariableUtil.processUsage(psiElement, variable, null, mode);
        }
    }

    static void collectReferences(@NotNull PsiElement context, final PsiVariable variable, final List<? super PsiElement> references) {
        context.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (expression2.resolve() == variable) {
                    references.add(expression2);
                }
                super.visitReferenceExpression(expression2);
            }
        });
    }

    static Boolean processUsage(PsiElement element, PsiVariable variable, List<? super PsiElement> sideEffects, @NotNull RemoveMode deleteMode) throws IncorrectOperationException {
        if (!element.isValid()) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
        while (element != null) {
            if (element instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression expression2 = (PsiAssignmentExpression)element;
                PsiExpression lExpression = expression2.getLExpression();
                if (!(lExpression instanceof PsiReferenceExpression) || variable != ((PsiReferenceExpression)lExpression).resolve()) {
                    return null;
                }
                PsiExpression rExpression = expression2.getRExpression();
                if ((rExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)rExpression)) == null) {
                    return true;
                }
                boolean sideEffectFound = RemoveUnusedVariableUtil.checkSideEffects(rExpression, variable, sideEffects);
                if (!ExpressionUtils.isVoidContext((PsiExpression)expression2) || PsiUtil.isStatement((PsiElement)rExpression)) {
                    if (deleteMode == RemoveMode.MAKE_STATEMENT || deleteMode == RemoveMode.DELETE_ALL && !ExpressionUtils.isVoidContext((PsiExpression)expression2)) {
                        element = RemoveUnusedVariableUtil.replaceElementWithExpression(rExpression, factory, element);
                        element = RemoveUnusedVariableUtil.eraseUnnecessaryOuterParentheses(element);
                        ArrayList references = new ArrayList();
                        RemoveUnusedVariableUtil.collectReferences(element, variable, references);
                        RemoveUnusedVariableUtil.deleteReferences(variable, references, deleteMode);
                    } else if (deleteMode == RemoveMode.DELETE_ALL) {
                        RemoveUnusedVariableUtil.deleteWholeStatement(element, factory);
                    }
                    return true;
                }
                if (deleteMode != RemoveMode.CANCEL) {
                    RemoveUnusedVariableUtil.deleteWholeStatement(element, factory);
                }
                return !sideEffectFound;
            }
            if (element instanceof PsiExpressionStatement && deleteMode != RemoveMode.CANCEL) {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiIfStatement || parent instanceof PsiLoopStatement && ((PsiLoopStatement)parent).getBody() == element) {
                    element.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)element.getProject()).createStatementFromText(";", element));
                    break;
                }
                element.delete();
                break;
            }
            if (element instanceof PsiVariable && element == variable) {
                PsiExpression expression3 = variable.getInitializer();
                if (expression3 != null) {
                    expression3 = PsiUtil.deparenthesizeExpression((PsiExpression)expression3);
                }
                boolean sideEffectsFound = RemoveUnusedVariableUtil.checkSideEffects(expression3, variable, sideEffects);
                if (expression3 != null && PsiUtil.isStatement((PsiElement)expression3) && variable instanceof PsiLocalVariable && (!(variable.getParent() instanceof PsiDeclarationStatement) || ((PsiDeclarationStatement)variable.getParent()).getDeclaredElements().length <= 1)) {
                    if (deleteMode == RemoveMode.MAKE_STATEMENT) {
                        element = element.getParent().replace(RemoveUnusedVariableUtil.createStatementIfNeeded(expression3, factory, element));
                        ArrayList references = new ArrayList();
                        RemoveUnusedVariableUtil.collectReferences(element, variable, references);
                        RemoveUnusedVariableUtil.deleteReferences(variable, references, deleteMode);
                    } else if (deleteMode == RemoveMode.DELETE_ALL) {
                        element.delete();
                    }
                    return true;
                }
                if (deleteMode != RemoveMode.CANCEL) {
                    if (element instanceof PsiField) {
                        ((PsiField)element).normalizeDeclaration();
                    }
                    element.delete();
                }
                return !sideEffectsFound;
            }
            element = element.getParent();
        }
        return true;
    }

    @NotNull
    private static PsiElement eraseUnnecessaryOuterParentheses(@NotNull PsiElement element) {
        PsiElement parenthesizedParent = element;
        while (parenthesizedParent.getParent() instanceof PsiParenthesizedExpression) {
            parenthesizedParent = parenthesizedParent.getParent();
        }
        if (parenthesizedParent != element) {
            return parenthesizedParent.replace(element);
        }
        return element;
    }

    public static boolean isForLoopUpdate(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof PsiForStatement && ((PsiForStatement)parent).getUpdate() == element;
    }

    public static enum RemoveMode {
        MAKE_STATEMENT,
        DELETE_ALL,
        CANCEL;

    }
}

