/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceInaccessibleFieldWithGetterSetterFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myMethodName;
    private final boolean myIsSetter;

    public ReplaceInaccessibleFieldWithGetterSetterFix(@NotNull PsiElement element, @NotNull PsiMethod getter, boolean isSetter) {
        super(element);
        this.myMethodName = getter.getName();
        this.myIsSetter = isSetter;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiReferenceExpression place = (PsiReferenceExpression)startElement;
        String qualifier = null;
        PsiExpression qualifierExpression2 = place.getQualifierExpression();
        if (qualifierExpression2 != null) {
            qualifier = qualifierExpression2.getText();
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        String call = (qualifier != null ? qualifier + "." : "") + this.myMethodName;
        if (!this.myIsSetter) {
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)elementFactory.createExpressionFromText(call + "()", null);
            callExpression = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)callExpression);
            place.replace((PsiElement)callExpression);
        } else {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)place, (Class[])new Class[]{PsiParenthesizedExpression.class});
            if (parent instanceof PsiAssignmentExpression) {
                PsiExpression rExpression = ((PsiAssignmentExpression)parent).getRExpression();
                String argList = rExpression != null ? rExpression.getText() : "";
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)elementFactory.createExpressionFromText(call + "(" + argList + ")", null);
                callExpression = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)callExpression);
                parent.replace((PsiElement)callExpression);
            }
        }
    }

    @NotNull
    public String getText() {
        return this.myIsSetter ? "Replace with setter" : "Replace with getter";
    }

    @NotNull
    public String getFamilyName() {
        return "Replace with getter/setter";
    }
}

