/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.scope.processor.VariablesNotProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReuseVariableDeclarationFix
implements IntentionAction {
    private final PsiLocalVariable myVariable;

    public ReuseVariableDeclarationFix(@NotNull PsiLocalVariable variable) {
        this.myVariable = variable;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("reuse.variable.declaration.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("reuse.variable.declaration.text", this.myVariable.getName());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!this.myVariable.isValid()) {
            return false;
        }
        PsiVariable previousVariable = ReuseVariableDeclarationFix.findPreviousVariable(this.myVariable);
        return previousVariable != null && Comparing.equal((Object)previousVariable.getType(), (Object)this.myVariable.getType()) && BaseIntentionAction.canModify((PsiElement)this.myVariable);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.myVariable;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiVariable refVariable = ReuseVariableDeclarationFix.findPreviousVariable(this.myVariable);
        if (refVariable == null) {
            return;
        }
        PsiExpression initializer = this.myVariable.getInitializer();
        if (initializer == null) {
            this.myVariable.delete();
            return;
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)refVariable, (String)"final", (boolean)false);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myVariable.getProject());
        PsiStatement statement = factory.createStatementFromText(this.myVariable.getName() + " = " + initializer.getText() + ";", null);
        this.myVariable.getParent().replace((PsiElement)statement);
    }

    @Nullable
    static PsiVariable findPreviousVariable(PsiLocalVariable variable) {
        PsiElement scope;
        for (scope = variable.getParent(); !(scope == null || scope instanceof PsiFile || scope instanceof PsiMethod || scope instanceof PsiClassInitializer); scope = scope.getParent()) {
        }
        if (scope == null) {
            return null;
        }
        PsiIdentifier nameIdentifier = variable.getNameIdentifier();
        if (nameIdentifier == null) {
            return null;
        }
        VariablesNotProcessor processor = new VariablesNotProcessor((PsiVariable)variable, false);
        PsiScopesUtil.treeWalkUp(processor, (PsiElement)nameIdentifier, scope);
        return processor.size() > 0 ? processor.getResult(0) : null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

