/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeDeleteFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public SafeDeleteFix(@NotNull PsiElement element) {
        super(element);
    }

    @NotNull
    public String getText() {
        PsiElement startElement = this.getStartElement();
        String text2 = startElement == null ? "" : HighlightMessageUtil.getSymbolName(startElement, PsiSubstitutor.EMPTY, 262146);
        return QuickFixBundle.message("safe.delete.text", ObjectUtils.notNull((Object)text2, (Object)""));
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("safe.delete.family", new Object[0]);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiElement[] elements = new PsiElement[]{startElement};
        if (startElement instanceof PsiParameter) {
            SafeDeleteProcessor.createInstance((Project)project, null, (PsiElement[])elements, (boolean)false, (boolean)false, (boolean)true).run();
        } else {
            SafeDeleteHandler.invoke((Project)project, (PsiElement[])elements, (boolean)true);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

