/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticMembersProcessor;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StaticImportMemberFix<T extends PsiMember, R extends PsiElement>
implements IntentionAction,
HintAction {
    private final List<T> candidates;
    protected final SmartPsiElementPointer<R> myRef;

    StaticImportMemberFix(@NotNull PsiFile file, @NotNull R reference) {
        this.myRef = SmartPointerManager.getInstance((Project)file.getProject()).createSmartPsiElementPointer(reference);
        this.candidates = this.getMembersToImport(false, StaticMembersProcessor.SearchMode.MAX_2_MEMBERS);
    }

    @NotNull
    protected abstract String getBaseText();

    @NotNull
    protected abstract String getMemberPresentableText(@NotNull T var1);

    @NotNull
    public String getText() {
        return this.getBaseText() + (this.candidates == null || this.candidates.size() != 1 ? "..." : " '" + this.getMemberPresentableText((PsiMember)this.candidates.get(0)) + "'");
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && file instanceof PsiJavaFile && this.getElement() != null && this.getElement().isValid() && this.getQualifierExpression() == null && this.resolveRef() == null && BaseIntentionAction.canModify((PsiElement)file) && !this.candidates.isEmpty() && ContainerUtil.all(this.candidates, PsiElement::isValid);
    }

    @NotNull
    protected abstract List<T> getMembersToImport(boolean var1, @NotNull StaticMembersProcessor.SearchMode var2);

    protected abstract boolean toAddStaticImports();

    public static boolean isExcluded(@NotNull PsiMember method) {
        String name = PsiUtil.getMemberQualifiedName((PsiMember)method);
        return name != null && JavaProjectCodeInsightSettings.getSettings(method.getProject()).isExcluded(name);
    }

    @NotNull
    protected abstract QuestionAction createQuestionAction(@NotNull List<? extends T> var1, @NotNull Project var2, Editor var3);

    @Nullable
    protected abstract PsiElement getElement();

    @Nullable
    protected abstract PsiElement getQualifierExpression();

    @Nullable
    protected abstract PsiElement resolveRef();

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            List<T> methodsToImport = this.getMembersToImport(false, StaticMembersProcessor.SearchMode.MAX_100_MEMBERS);
            if (methodsToImport.isEmpty()) {
                return;
            }
            this.createQuestionAction(methodsToImport, project, editor).execute();
        });
    }

    @NotNull
    private ImportClassFixBase.Result doFix(@NotNull Editor editor) {
        if (!CodeInsightSettings.getInstance().ADD_MEMBER_IMPORTS_ON_THE_FLY) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        List<T> candidates = this.getMembersToImport(true, StaticMembersProcessor.SearchMode.MAX_100_MEMBERS);
        if (candidates.isEmpty()) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        PsiElement element = this.getElement();
        if (element == null) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        if (this.toAddStaticImports() && candidates.size() == 1 && PsiTreeUtil.isAncestor((PsiElement)element.getContainingFile(), (PsiElement)((PsiElement)candidates.get(0)), (boolean)true)) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        QuestionAction action = this.createQuestionAction(candidates, element.getProject(), editor);
        String hintText = ShowAutoImportPass.getMessage((candidates.size() > 1 ? 1 : 0) != 0, (String)this.getMemberPresentableText((PsiMember)candidates.get(0)));
        if (!ApplicationManager.getApplication().isUnitTestMode() && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            TextRange textRange = element.getTextRange();
            HintManager.getInstance().showQuestionHint(editor, hintText, textRange.getStartOffset(), textRange.getEndOffset(), action);
        }
        return ImportClassFixBase.Result.POPUP_SHOWN;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean showHint(@NotNull Editor editor) {
        PsiElement callExpression = this.getElement();
        if (callExpression == null || this.getQualifierExpression() != null) {
            return false;
        }
        ImportClassFixBase.Result result = this.doFix(editor);
        return result == ImportClassFixBase.Result.POPUP_SHOWN || result == ImportClassFixBase.Result.CLASS_AUTO_IMPORTED;
    }
}

