/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMemberFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticMembersProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticImportMethodFix
extends StaticImportMemberFix<PsiMethod, PsiMethodCallExpression> {
    public StaticImportMethodFix(@NotNull PsiFile file, @NotNull PsiMethodCallExpression methodCallExpression) {
        super(file, methodCallExpression);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        return QuickFixBundle.message("static.import.method.text", new Object[0]);
    }

    @Override
    @NotNull
    protected String getMemberPresentableText(@NotNull PsiMethod method) {
        return PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)0);
    }

    @Override
    @NotNull
    protected List<PsiMethod> getMembersToImport(boolean applicableOnly, @NotNull StaticMembersProcessor.SearchMode searchMode) {
        String name;
        Project project = this.myRef.getProject();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
        PsiMethodCallExpression element = (PsiMethodCallExpression)this.myRef.getElement();
        PsiReferenceExpression reference = element == null ? null : element.getMethodExpression();
        String string = name = reference == null ? null : reference.getReferenceName();
        if (name == null) {
            return Collections.emptyList();
        }
        MyStaticMethodProcessor processor = new MyStaticMethodProcessor(element, this.toAddStaticImports(), searchMode);
        cache.processMethodsWithName(name, element.getResolveScope(), (Processor)processor);
        return processor.getMembersToImport(applicableOnly);
    }

    @Override
    protected boolean toAddStaticImports() {
        return true;
    }

    @NotNull
    protected StaticImportMethodQuestionAction<PsiMethod> createQuestionAction(@NotNull List<? extends PsiMethod> methodsToImport, @NotNull Project project, Editor editor) {
        return new StaticImportMethodQuestionAction<PsiMethod>(project, editor, methodsToImport, (SmartPsiElementPointer<? extends PsiElement>)this.myRef);
    }

    @Override
    @Nullable
    protected PsiElement getElement() {
        return this.myRef.getElement();
    }

    @Override
    @Nullable
    protected PsiElement getQualifierExpression() {
        PsiMethodCallExpression element = (PsiMethodCallExpression)this.myRef.getElement();
        return element != null ? element.getMethodExpression().getQualifierExpression() : null;
    }

    @Override
    @Nullable
    protected PsiElement resolveRef() {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)this.getElement();
        return methodCallExpression != null ? methodCallExpression.resolveMethod() : null;
    }

    private static class MyStaticMethodProcessor
    extends StaticMembersProcessor<PsiMethod> {
        private MyStaticMethodProcessor(@NotNull PsiMethodCallExpression place, boolean showMembersFromDefaultPackage, @NotNull StaticMembersProcessor.SearchMode mode) {
            super((PsiElement)place, showMembersFromDefaultPackage, mode);
        }

        @Override
        protected boolean isApplicable(PsiMethod method, PsiElement place) {
            ProgressManager.checkCanceled();
            PsiExpressionList argumentList = ((PsiMethodCallExpression)place).getArgumentList();
            MethodCandidateInfo candidateInfo = new MethodCandidateInfo((PsiElement)method, PsiSubstitutor.EMPTY, false, false, (PsiElement)argumentList, null, argumentList.getExpressionTypes(), null);
            PsiSubstitutor substitutorForMethod = candidateInfo.getSubstitutor();
            if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)substitutorForMethod, (PsiExpressionList)argumentList)) {
                PsiType returnType = substitutorForMethod.substitute(method.getReturnType());
                if (returnType == null) {
                    return true;
                }
                return this.isApplicableFor(returnType);
            }
            return false;
        }
    }
}

